/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import ovh.corail.tombstone.helper.Helper;

abstract class CustomParticle
extends Particle {
    protected static final float DEFAULT_ROLL = 0.31415927f;
    protected float rollIncrement = 0.0f;
    protected float quadSize = 0.2f;
    private Supplier<Float> alphaSupplier = null;
    private Runnable colorSetter = null;

    CustomParticle(ClientLevel level, Vec3 vec) {
        this(level, vec.x, vec.y, vec.z);
    }

    CustomParticle(ClientLevel level, double x, double y, double z) {
        this(level, x, y, z, 0.0, 0.0, 0.0);
    }

    CustomParticle(ClientLevel level, double x, double y, double z, double mX, double mY, double mZ) {
        super(level, x, y, z);
        this.xd = mX;
        this.yd = mY;
        this.zd = mZ;
        this.hasPhysics = false;
    }

    protected boolean requireRemoval() {
        return this.age >= this.lifetime;
    }

    public void tick() {
        if (this.requireRemoval()) {
            this.remove();
        } else {
            ++this.age;
            this.updateLastPos();
            this.updatePosition();
            this.update();
        }
    }

    public Particle scale(float scale) {
        this.quadSize *= scale;
        this.setSize(this.quadSize, this.quadSize);
        return this;
    }

    protected void updatePosition() {
        if (this.xd != 0.0 || this.yd != 0.0 || this.zd != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(this.xd, this.yd, this.zd));
            this.setLocationFromBoundingbox();
        }
    }

    protected void update() {
        if (this.rollIncrement > 0.0f) {
            this.oRoll = this.roll;
            this.roll += this.rollIncrement;
        }
        if (this.colorSetter != null) {
            this.colorSetter.run();
        }
        if (this.alphaSupplier != null) {
            this.alpha = this.alphaSupplier.get().floatValue();
        }
    }

    protected void updateLastPos() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
    }

    public CustomParticle withColor(int color) {
        float[] colors = Helper.getRGBColor3F(color);
        this.setColor(colors[0], colors[1], colors[2]);
        return this;
    }

    public CustomParticle withColor(Supplier<Float> func) {
        this.colorSetter = () -> {
            float color = ((Float)func.get()).floatValue();
            this.setColor(color, color, color);
        };
        return this;
    }

    public void setRolling(float rollIncrement) {
        this.setRolling((float)Math.PI * 2 * Helper.RANDOM.nextFloat(), rollIncrement);
    }

    public void setRolling(float rollStart, float rollIncrement) {
        if (rollIncrement != 0.0f) {
            this.roll = rollStart;
            this.rollIncrement = rollIncrement;
            this.oRoll = this.roll - this.rollIncrement;
        } else {
            this.roll = this.oRoll = rollStart;
            this.rollIncrement = 0.0f;
        }
    }

    public void setAlpha(float alpha) {
        this.alphaSupplier = null;
        this.alpha = alpha;
    }

    public void setAlpha(Supplier<Float> alphaSupplier) {
        this.alphaSupplier = alphaSupplier;
        this.alpha = alphaSupplier.get().floatValue();
    }

    protected float getU0() {
        return 0.0f;
    }

    protected float getU1() {
        return 1.0f;
    }

    protected float getV0() {
        return 0.0f;
    }

    protected float getV1() {
        return 1.0f;
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 vecFromCamera = new Vec3(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x), Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y), Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z)).subtract(renderInfo.getPosition());
        int light = this.getLightColor(partialTicks);
        Quaternionf rollTransform = this.getRollQuaternion(renderInfo, partialTicks);
        Vector3f[] vecFaceQuad = this.getFaceQuad();
        Arrays.stream(vecFaceQuad).forEach(v -> {
            v.rotate((Quaternionfc)rollTransform);
            v.mul(this.quadSize);
            v.add((float)vecFromCamera.x, (float)vecFromCamera.y, (float)vecFromCamera.z);
        });
        this.addQuad(buffer, vecFaceQuad, light);
    }

    protected Quaternionf getRollQuaternion(Camera renderInfo, float partialTicks) {
        if (this.roll == 0.0f) {
            return renderInfo.rotation();
        }
        Quaternionf rollTransform = new Quaternionf((Quaternionfc)renderInfo.rotation());
        rollTransform.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        return rollTransform;
    }

    protected Vector3f[] getFaceQuad() {
        return new Vector3f[]{new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
    }

    protected void addQuad(VertexConsumer buffer, Vector3f[] points, int light) {
        buffer.addVertex(points[0].x(), points[0].y(), points[0].z()).setUv(this.getU1(), this.getV1()).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
        buffer.addVertex(points[1].x(), points[1].y(), points[1].z()).setUv(this.getU1(), this.getV0()).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
        buffer.addVertex(points[2].x(), points[2].y(), points[2].z()).setUv(this.getU0(), this.getV0()).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
        buffer.addVertex(points[3].x(), points[3].y(), points[3].z()).setUv(this.getU0(), this.getV1()).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
    }
}

