/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.world.entity.LivingEntity;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.BoundParticle;
import ovh.corail.tombstone.particle.ParticleRenderTypes;

public final class ParticleCasting
extends BoundParticle {
    private final Predicate<LivingEntity> requireRemoval;

    public ParticleCasting(ClientLevel level, LivingEntity caster, Predicate<LivingEntity> requireRemoval) {
        super(level, caster, 1.1);
        this.requireRemoval = requireRemoval;
        this.setRolling(0.15707964f);
        this.withColor((Integer)ConfigTombstone.client.particleCastingColor.get());
    }

    @Override
    protected void addParticleDatas(List<BoundParticle.ParticleData> datas) {
        int count = 6;
        double addY = 0.4;
        for (int part = 0; part < 6; ++part) {
            datas.add(new CastingData(this, this.level.random.nextFloat() * 0.3f + 0.5f, (double)(Helper.RANDOM.nextFloat() * (float)Math.PI), addY, 0.0f));
            datas.add(new CastingData(this, this.level.random.nextFloat() * 0.3f + 0.5f, (double)((1.0f + Helper.RANDOM.nextFloat()) * (float)Math.PI), addY, (float)Math.PI));
            addY += 0.25;
        }
    }

    @Override
    protected void onParticleDataUpdate(BoundParticle.ParticleData data, double ratio) {
        CastingData castingData = (CastingData)data;
        if (castingData.yHeight > 2.0 || castingData.yHeight < 0.2) {
            castingData.goUp = !castingData.goUp;
        }
        castingData.yHeight = castingData.yHeight + (castingData.goUp ? 0.02 : -0.02);
        super.onParticleDataUpdate(data, ratio);
    }

    @Override
    protected boolean requireRemoval() {
        return Optional.ofNullable((LivingEntity)this.entityWeakReference.get()).map(this.requireRemoval::test).orElse(true);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderTypes.CASTING;
    }

    private class CastingData
    extends BoundParticle.ParticleData {
        private boolean goUp;

        protected CastingData(ParticleCasting particleCasting, float size, double angle, double yHeight, float startRoll) {
            super(particleCasting, size, angle, yHeight, startRoll);
            this.goUp = yHeight < 1.0;
        }
    }
}

