/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ParticleRenderTypes {
    public static final RenderPipeline LOW_ALPHA_RENDER_PIPELINE = ParticleRenderTypes.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.PARTICLE_SNIPPET}).withLocation("pipeline/low_alpha_particle").withFragmentShader("core/alphal").withDepthWrite(false).withBlend(BlendFunction.TRANSLUCENT).build());
    private static final Function<ResourceLocation, RenderType> LOW_ALPHA_PARTICLE = Util.memoize(rl -> RenderType.create((String)"low_alpha_particle", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)LOW_ALPHA_RENDER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(rl, false)).setOutputState(RenderType.PARTICLES_TARGET).setLightmapState(RenderType.LIGHTMAP).createCompositeState(false)));
    public static final ParticleRenderType SOUL = new ParticleRenderType("TB_SOUL", LOW_ALPHA_PARTICLE.apply(Textures.SOUL));
    public static final ParticleRenderType GHOST = new ParticleRenderType("TB_GHOST", LOW_ALPHA_PARTICLE.apply(Textures.GHOST));
    public static final ParticleRenderType SMOKE = new ParticleRenderType("TB_SMOKE", LOW_ALPHA_PARTICLE.apply(Textures.SMOKE));
    public static final ParticleRenderType WING = new ParticleRenderType("TB_WING", LOW_ALPHA_PARTICLE.apply(Textures.WING));
    public static final ParticleRenderType GLOW = new ParticleRenderType("TB_GLOW", LOW_ALPHA_PARTICLE.apply(Textures.GLOW));
    public static final ParticleRenderType NOTE = new ParticleRenderType("TB_NOTE", LOW_ALPHA_PARTICLE.apply(Textures.NOTE));
    public static final ParticleRenderType AURA = new ParticleRenderType("TB_AURA", LOW_ALPHA_PARTICLE.apply(Textures.AURA));
    public static final ParticleRenderType CASTING = new ParticleRenderType("TB_CASTING", LOW_ALPHA_PARTICLE.apply(Textures.CASTING));
    public static final ParticleRenderType HEART = new ParticleRenderType("TB_HEART", (RenderType)RenderType.OPAQUE_PARTICLE.apply(Textures.HEART));
    public static final ParticleRenderType SHIELD = new ParticleRenderType("TB_SHIELD", (RenderType)RenderType.OPAQUE_PARTICLE.apply(Textures.SHIELD));
    public static final ParticleRenderType BONE = new ParticleRenderType("TB_BONE", (RenderType)RenderType.OPAQUE_PARTICLE.apply(Textures.BONE));
    public static final ParticleRenderType ANKH = new ParticleRenderType("TB_ANKH", (RenderType)RenderType.OPAQUE_PARTICLE.apply(Textures.ANKH));
    public static final ParticleRenderType GHAST_TEAR = new ParticleRenderType("TB_GHAST_TEAR", (RenderType)RenderType.OPAQUE_PARTICLE.apply(Textures.GHAST_TEAR));
    public static final ParticleRenderType GOLD_HEART = new ParticleRenderType("TB_GOLD_HEART", (RenderType)RenderType.OPAQUE_PARTICLE.apply(Textures.GOLD_HEART));
    public static final ParticleRenderType BLACK_NOTE = new ParticleRenderType("TB_BLACK_NOTE", (RenderType)RenderType.OPAQUE_PARTICLE.apply(Textures.NOTE));

    private static RenderPipeline register(RenderPipeline renderPipeline) {
        RenderPipelines.PIPELINES_BY_LOCATION.put(renderPipeline.getLocation(), renderPipeline);
        return renderPipeline;
    }

    private static class Textures {
        private static final ResourceLocation SOUL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/particle/soul.png");
        private static final ResourceLocation GHOST = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/particle/ghost.png");
        private static final ResourceLocation SMOKE = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/particle/fake_fog.png");
        private static final ResourceLocation WING = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/item/revive.png");
        private static final ResourceLocation GLOW = ResourceLocation.withDefaultNamespace((String)"textures/particle/glow.png");
        private static final ResourceLocation NOTE = ResourceLocation.withDefaultNamespace((String)"textures/particle/note.png");
        private static final ResourceLocation AURA = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/aura/aura1.png");
        private static final ResourceLocation CASTING = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/particle/casting.png");
        private static final ResourceLocation HEART = ResourceLocation.withDefaultNamespace((String)"textures/particle/heart.png");
        private static final ResourceLocation SHIELD = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/item/pray_of_protection.png");
        private static final ResourceLocation BONE = ResourceLocation.withDefaultNamespace((String)"textures/item/bone.png");
        private static final ResourceLocation ANKH = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/item/ankh.png");
        private static final ResourceLocation GHAST_TEAR = ResourceLocation.withDefaultNamespace((String)"textures/item/ghast_tear.png");
        private static final ResourceLocation GOLD_HEART = ResourceLocation.withDefaultNamespace((String)"textures/particle/gold_heart.png");

        private Textures() {
        }
    }
}

