/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public abstract class AbstractCombinableRecipe
implements CraftingRecipe {
    protected final String group;
    protected final CraftingBookCategory category;
    protected final Ingredient input;
    protected final Ingredient material;
    protected final ItemStack result;
    @Nullable
    protected PlacementInfo placementInfo;

    public AbstractCombinableRecipe(String group, CraftingBookCategory category, Ingredient input, Ingredient material, ItemStack result) {
        this.group = group;
        this.category = category;
        this.input = input;
        this.material = material;
        this.result = result;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(List.of(this.input, this.material));
        }
        return this.placementInfo;
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(List.of(this.input.display(), this.material.display()), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public String group() {
        return this.group;
    }

    public abstract RecipeSerializer<? extends AbstractCombinableRecipe> getSerializer();

    public static class Serializer<T extends AbstractCombinableRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(c -> c.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Ingredient.CODEC.fieldOf("material").forGetter(r -> r.material), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result)).apply((Applicative)c, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.group, (StreamCodec)CraftingBookCategory.STREAM_CODEC, r -> r.category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.input, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.material, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.result, factory::create);

        public Serializer(Factory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface Factory<T extends AbstractCombinableRecipe> {
        public T create(String var1, CraftingBookCategory var2, Ingredient var3, Ingredient var4, ItemStack var5);
    }
}

