/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.registry.ModSerializers;

public class DisableableShapedRecipe
implements CraftingRecipe {
    final ShapedRecipePattern pattern;
    final ItemStack result;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;
    @Nullable
    private PlacementInfo placementInfo;

    public DisableableShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = result;
        this.showNotification = showNotification;
    }

    public RecipeSerializer<? extends CraftingRecipe> getSerializer() {
        return ModSerializers.DISABLEABLE_SHAPED;
    }

    public String group() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    @VisibleForTesting
    public List<Optional<Ingredient>> getIngredients() {
        return this.pattern.ingredients();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals((List)this.pattern.ingredients());
        }
        return this.placementInfo;
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public boolean matches(CraftingInput inv, Level level) {
        IDisableable disableable;
        Item item = this.result.getItem();
        if (item instanceof IDisableable && !(disableable = (IDisableable)item).isEnabled()) {
            return false;
        }
        return this.pattern.matches(inv);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapedCraftingRecipeDisplay(this.pattern.width(), this.pattern.height(), this.pattern.ingredients().stream().map(p_380107_ -> p_380107_.map(Ingredient::display).orElse((SlotDisplay)SlotDisplay.Empty.INSTANCE)).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    public static class Serializer
    implements RecipeSerializer<DisableableShapedRecipe> {
        private static final MapCodec<DisableableShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(r -> r.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(r -> r.showNotification)).apply((Applicative)codec, DisableableShapedRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, DisableableShapedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<DisableableShapedRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DisableableShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static DisableableShapedRecipe fromNetwork(RegistryFriendlyByteBuf byteBuf) {
            String group = byteBuf.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)byteBuf.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)byteBuf);
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)byteBuf);
            boolean showNotification = byteBuf.readBoolean();
            return new DisableableShapedRecipe(group, craftingbookcategory, shapedrecipepattern, stack, showNotification);
        }

        private static void toNetwork(RegistryFriendlyByteBuf byteBuf, DisableableShapedRecipe recipe) {
            byteBuf.writeUtf(recipe.group);
            byteBuf.writeEnum((Enum)recipe.category);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)byteBuf, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)byteBuf, (Object)recipe.result);
            byteBuf.writeBoolean(recipe.showNotification);
        }
    }
}

