/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.registry.ModSerializers;

public class DisableableShapelessRecipe
implements CraftingRecipe {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final List<Ingredient> ingredients;
    @Nullable
    private PlacementInfo placementInfo;
    private final boolean isSimple;

    public DisableableShapelessRecipe(String group, CraftingBookCategory category, ItemStack result, List<Ingredient> ingredients) {
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    public RecipeSerializer<? extends CraftingRecipe> getSerializer() {
        return ModSerializers.DISABLEABLE_SHAPELESS;
    }

    public String group() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(this.ingredients);
        }
        return this.placementInfo;
    }

    public boolean matches(CraftingInput inv, Level level) {
        IDisableable disableable;
        Item item = this.result.getItem();
        if (item instanceof IDisableable && !(disableable = (IDisableable)item).isEnabled()) {
            return false;
        }
        if (inv.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (!this.isSimple) {
            ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(inv.ingredientCount());
            for (ItemStack item2 : inv.items()) {
                if (item2.isEmpty()) continue;
                nonEmptyItems.add(item2);
            }
            return RecipeMatcher.findMatches(nonEmptyItems, this.ingredients) != null;
        }
        return inv.size() == 1 && this.ingredients.size() == 1 ? this.ingredients.getFirst().test(inv.getItem(0)) : inv.stackedContents().canCraft((Recipe)this, null);
    }

    public ItemStack assemble(CraftingInput pInput, HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(this.ingredients.stream().map(Ingredient::display).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    public static class Serializer
    implements RecipeSerializer<DisableableShapelessRecipe> {
        private static final MapCodec<DisableableShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Ingredient.CODEC.listOf(1, 9).fieldOf("ingredients").forGetter(r -> r.ingredients)).apply((Applicative)codec, DisableableShapelessRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, DisableableShapelessRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.group, (StreamCodec)CraftingBookCategory.STREAM_CODEC, r -> r.category, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.result, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.ingredients, DisableableShapelessRecipe::new);

        public MapCodec<DisableableShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DisableableShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

