/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.recipe.AbstractCombinableRecipe;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSerializers;
import ovh.corail.tombstone.registry.ModTags;

public final class RecipeEnchantedGraveKey
extends AbstractCombinableRecipe {
    public RecipeEnchantedGraveKey(String group, CraftingBookCategory category, Ingredient input, Ingredient material, ItemStack result) {
        super(group, category, input, material, result);
    }

    public boolean matches(CraftingInput inv, Level level) {
        if (((Boolean)SharedConfigTombstone.magic_item.disableEnchantedGraveKeyRecipe.get()).booleanValue() || !ModItems.grave_key.isEnabled()) {
            return false;
        }
        boolean hasKey = false;
        boolean hasIngredient = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (!hasKey && stack.is((Item)ModItems.grave_key) && !ModItems.grave_key.isEnchanted(stack)) {
                hasKey = true;
                continue;
            }
            if (!hasIngredient && stack.is(ModTags.Items.enchanted_grave_key_ingredients)) {
                hasIngredient = true;
                continue;
            }
            return false;
        }
        return hasKey && hasIngredient;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        return IntStream.range(0, inv.size()).mapToObj(arg_0 -> ((CraftingInput)inv).getItem(arg_0)).filter(stack -> stack.is((Item)ModItems.grave_key)).findFirst().map(key -> {
            ItemStack result = key.copy();
            result.set(ModDataComponents.ENCHANTED, (Object)true);
            return result;
        }).orElse(ItemStack.EMPTY);
    }

    public RecipeSerializer<RecipeEnchantedGraveKey> getSerializer() {
        return ModSerializers.ENCHANTED_GRAVE_KEY;
    }
}

