/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterConditionalItemModelPropertyEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterRangeSelectItemModelPropertyEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.combine.ClientTooltipCombineCraft;
import ovh.corail.tombstone.combine.ClientTooltipCombineUpgrade;
import ovh.corail.tombstone.combine.ClientTooltipSimple;
import ovh.corail.tombstone.combine.TooltipCombineCraft;
import ovh.corail.tombstone.combine.TooltipCombineUpgrade;
import ovh.corail.tombstone.combine.TooltipDyeable;
import ovh.corail.tombstone.combine.TooltipEngravable;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.item.ItemLollipop;
import ovh.corail.tombstone.item.ItemMagicScroll;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.item.ItemSmokeBall;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.particle.ParticleSmokeCloud;
import ovh.corail.tombstone.particle.ParticleSmokeColumn;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModKeybinds;
import ovh.corail.tombstone.registry.ModParticleTypes;
import ovh.corail.tombstone.render.GraveGuardianCapeModel;
import ovh.corail.tombstone.render.GraveGuardianRenderer;
import ovh.corail.tombstone.render.RenderWritableGrave;
import ovh.corail.tombstone.render.SpectralBiteRenderer;
import ovh.corail.tombstone.render.SpectralWolfRenderer;

@EventBusSubscriber(modid="tombstone", value={Dist.CLIENT})
public final class ClientModEvents {
    public static final ModelLayerLocation GRAVE_GUARDIAN_CAPE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"grave_guardian_cape"), "grave_guardian_cape");

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"lollipop_color"), LollipopColor.MAP_CODEC);
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"smoke_ball_color"), SmokeBallColor.MAP_CODEC);
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"scroll_of_knowledge_color"), ScrollOfKnowledgeColor.MAP_CODEC);
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"magic_scroll_color"), MagicScrollColorTint.MAP_CODEC);
    }

    @SubscribeEvent
    public static void registerModelProperties(RegisterConditionalItemModelPropertyEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"is_ancient"), IsAncientItemProperty.MAP_CODEC);
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"is_engraved"), IsEngravedItemProperty.MAP_CODEC);
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"bone_needle"), BoneNeedleItemProperty.MAP_CODEC);
    }

    @SubscribeEvent
    public static void registerModelProperties(RegisterRangeSelectItemModelPropertyEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"fishing_rod_of_misadventure"), FishingRodOfMisadventureItemProperty.MAP_CODEC);
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"decorative_grave"), DecorativeGraveItemProperty.MAP_CODEC);
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"lost_tablet"), LostTabletItemProperty.MAP_CODEC);
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"scroll_buff"), ScrollBuffItemProperty.MAP_CODEC);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlocks.tile_decorative_grave, RenderWritableGrave::new);
        event.registerBlockEntityRenderer(ModBlocks.tile_grave, RenderWritableGrave::new);
        event.registerEntityRenderer(ModEntities.cloud, NoopRenderer::new);
        event.registerEntityRenderer(ModEntities.spectral_bite, SpectralBiteRenderer::new);
        event.registerEntityRenderer(ModEntities.spectral_wolf, SpectralWolfRenderer::new);
        event.registerEntityRenderer(ModEntities.grave_guardian, GraveGuardianRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(GRAVE_GUARDIAN_CAPE, GraveGuardianCapeModel::createCapeLayer);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        particleEngine.register((ParticleType)ModParticleTypes.GHOST, (type, level, x, y, z, mX, mY, mZ) -> new ParticleGhost(level, x, y, z, (Helper.RANDOM.nextDouble() - 0.5) * 0.1, (Helper.RANDOM.nextDouble() - 0.5) * 0.1));
        particleEngine.register((ParticleType)ModParticleTypes.SMOKE_COLUMN, (type, level, x, y, z, mX, mY, mZ) -> new ParticleSmokeColumn(level, x, y, z));
        particleEngine.register((ParticleType)ModParticleTypes.SMOKE_CLOUD, (type, level, x, y, z, mX, mY, mZ) -> new ParticleSmokeCloud(level, x, y, z));
    }

    @SubscribeEvent
    public static void onRegisterTooltipComponentFactory(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(TooltipCombineCraft.class, ClientTooltipCombineCraft::new);
        event.register(TooltipCombineUpgrade.class, ClientTooltipCombineUpgrade::new);
        event.register(TooltipDyeable.class, ClientTooltipSimple::new);
        event.register(TooltipEngravable.class, ClientTooltipSimple::new);
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        ModKeybinds.KEYBIND_KNOWLEDGE = new KeyMapping(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "Corail Tombstone");
        event.register(ModKeybinds.KEYBIND_KNOWLEDGE);
        ModKeybinds.KEYBIND_CONFIG = new KeyMapping(LangKey.MESSAGE_CONFIG.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "Corail Tombstone");
        event.register(ModKeybinds.KEYBIND_CONFIG);
        ModKeybinds.KEYBIND_COMPENDIUM = new KeyMapping(LangKey.MESSAGE_COMPENDIUM.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "Corail Tombstone");
        event.register(ModKeybinds.KEYBIND_COMPENDIUM);
    }

    public record LollipopColor() implements ItemTintSource
    {
        private static final MapCodec<LollipopColor> MAP_CODEC = MapCodec.unit((Object)new LollipopColor());

        public int calculate(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
            return ARGB.opaque((int)ItemLollipop.getColor(stack, 0));
        }

        public MapCodec<LollipopColor> type() {
            return MAP_CODEC;
        }
    }

    public record SmokeBallColor() implements ItemTintSource
    {
        private static final MapCodec<SmokeBallColor> MAP_CODEC = MapCodec.unit((Object)new SmokeBallColor());

        public int calculate(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
            return ARGB.opaque((int)ItemSmokeBall.getColor(stack, 0));
        }

        public MapCodec<SmokeBallColor> type() {
            return MAP_CODEC;
        }
    }

    public record ScrollOfKnowledgeColor() implements ItemTintSource
    {
        private static final MapCodec<ScrollOfKnowledgeColor> MAP_CODEC = MapCodec.unit((Object)new ScrollOfKnowledgeColor());

        public int calculate(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
            return ARGB.opaque((int)(ModItems.scroll_of_knowledge.isEnchanted(stack) ? 65280 : -1));
        }

        public MapCodec<ScrollOfKnowledgeColor> type() {
            return MAP_CODEC;
        }
    }

    public record MagicScrollColorTint(int tintId) implements ItemTintSource
    {
        private static final MapCodec<MagicScrollColorTint> MAP_CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)Codec.INT.fieldOf("tint_id").forGetter(MagicScrollColorTint::tintId)).apply((Applicative)c, MagicScrollColorTint::new));

        public int calculate(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
            return ARGB.opaque((int)ItemMagicScroll.getColor(stack, this.tintId));
        }

        public MapCodec<MagicScrollColorTint> type() {
            return MAP_CODEC;
        }
    }

    public record IsAncientItemProperty() implements ConditionalItemModelProperty
    {
        private static final MapCodec<IsAncientItemProperty> MAP_CODEC = MapCodec.unit((Object)new IsAncientItemProperty());

        public boolean get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p_388905_, ItemDisplayContext context) {
            return ((ItemGraveMagic)stack.getItem()).isAncient(stack);
        }

        public MapCodec<IsAncientItemProperty> type() {
            return MAP_CODEC;
        }
    }

    public record IsEngravedItemProperty() implements ConditionalItemModelProperty
    {
        private static final MapCodec<IsEngravedItemProperty> MAP_CODEC = MapCodec.unit((Object)new IsEngravedItemProperty());

        public boolean get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p_388905_, ItemDisplayContext context) {
            return EngravableHelper.isEngraved(stack);
        }

        public MapCodec<IsEngravedItemProperty> type() {
            return MAP_CODEC;
        }
    }

    public record BoneNeedleItemProperty() implements ConditionalItemModelProperty
    {
        private static final MapCodec<BoneNeedleItemProperty> MAP_CODEC = MapCodec.unit((Object)new BoneNeedleItemProperty());

        public boolean get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p_388905_, ItemDisplayContext context) {
            return !ModItems.bone_needle.getEntityType(stack).isEmpty();
        }

        public MapCodec<BoneNeedleItemProperty> type() {
            return MAP_CODEC;
        }
    }

    public record FishingRodOfMisadventureItemProperty() implements RangeSelectItemModelProperty
    {
        private static final MapCodec<FishingRodOfMisadventureItemProperty> MAP_CODEC = MapCodec.unit((Object)new FishingRodOfMisadventureItemProperty());

        public float get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p_388905_) {
            Player player;
            return (ModItems.fishing_rod_of_misadventure.isAncient(stack) ? 1.0f : 0.0f) + (entity instanceof Player && ((player = (Player)entity).getMainHandItem() == stack || player.getOffhandItem() == stack) && player.fishing != null ? 0.5f : 0.0f);
        }

        public MapCodec<FishingRodOfMisadventureItemProperty> type() {
            return MAP_CODEC;
        }
    }

    public record DecorativeGraveItemProperty() implements RangeSelectItemModelProperty
    {
        private static final MapCodec<DecorativeGraveItemProperty> MAP_CODEC = MapCodec.unit((Object)new DecorativeGraveItemProperty());

        public float get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p_388905_) {
            return (float)ItemBlockGrave.getModelTexture(stack) * 1.0f + (EngravableHelper.isEngraved(stack) ? 0.5f : 0.0f);
        }

        public MapCodec<DecorativeGraveItemProperty> type() {
            return MAP_CODEC;
        }
    }

    public record LostTabletItemProperty() implements RangeSelectItemModelProperty
    {
        private static final MapCodec<LostTabletItemProperty> MAP_CODEC = MapCodec.unit((Object)new LostTabletItemProperty());

        public float get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p_388905_) {
            return ModItems.lost_tablet.getType(stack).ordinal();
        }

        public MapCodec<LostTabletItemProperty> type() {
            return MAP_CODEC;
        }
    }

    public record ScrollBuffItemProperty() implements RangeSelectItemModelProperty
    {
        private static final MapCodec<ScrollBuffItemProperty> MAP_CODEC = MapCodec.unit((Object)new ScrollBuffItemProperty());

        public float get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p_388905_) {
            ItemScroll scroll = (ItemScroll)stack.getItem();
            return scroll.isAncient(stack) ? 1.0f : (scroll.isEnchanted(stack) ? 0.5f : 0.0f);
        }

        public MapCodec<ScrollBuffItemProperty> type() {
            return MAP_CODEC;
        }
    }
}

