/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.RegisterEvent;
import ovh.corail.tombstone.block.BlockAbandonedGrave;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.block.ItemBlockGraveMarble;
import ovh.corail.tombstone.block.entity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.block.entity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModTags;

public final class ModBlocks {
    public static final EnumMap<GraveModel, Block> PLAYER_GRAVES = new EnumMap(GraveModel.class);
    public static final EnumMap<GraveModel, Block> DECORATIVE_GRAVES = new EnumMap(GraveModel.class);
    public static BlockEntityType<BlockEntityPlayerGrave> tile_grave = (BlockEntityType)Helper.unsafeNullCast();
    public static BlockEntityType<BlockEntityDecorativeGrave> tile_decorative_grave = (BlockEntityType)Helper.unsafeNullCast();
    public static Block abandoned_grave = (Block)Helper.unsafeNullCast();
    public static Block dark_marble = (Block)Helper.unsafeNullCast();
    public static Block white_marble = (Block)Helper.unsafeNullCast();
    public static Block blue_marble = (Block)Helper.unsafeNullCast();
    public static Block green_marble = (Block)Helper.unsafeNullCast();
    public static Block carmin_marble = (Block)Helper.unsafeNullCast();
    public static Block dark_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block white_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block blue_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block green_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block carmin_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block dark_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block white_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block blue_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block green_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block carmin_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block dark_marble_wall = (Block)Helper.unsafeNullCast();
    public static Block white_marble_wall = (Block)Helper.unsafeNullCast();
    public static Block blue_marble_wall = (Block)Helper.unsafeNullCast();
    public static Block green_marble_wall = (Block)Helper.unsafeNullCast();
    public static Block carmin_marble_wall = (Block)Helper.unsafeNullCast();
    public static Block thornveil = (Block)Helper.unsafeNullCast();

    public static boolean isPlayerGrave(Block block) {
        return PLAYER_GRAVES.containsValue(block);
    }

    public static boolean isDecorativeGrave(Block block) {
        return DECORATIVE_GRAVES.containsValue(block);
    }

    public static boolean isAnyGrave(Block block) {
        return ModBlocks.isPlayerGrave(block) || ModBlocks.isDecorativeGrave(block);
    }

    static void onRegisterBlocks(RegisterEvent event) {
        Arrays.stream(GraveModel.values()).forEach(model -> {
            BlockGrave playerGrave = new BlockGrave((GraveModel)((Object)model));
            PLAYER_GRAVES.put((GraveModel)((Object)model), (Block)playerGrave);
            ModBlocks.register(event, (Block)playerGrave);
            BlockDecorativeGrave decorativeGrave = new BlockDecorativeGrave((GraveModel)((Object)model));
            DECORATIVE_GRAVES.put((GraveModel)((Object)model), (Block)decorativeGrave);
            ModBlocks.register(event, (Block)decorativeGrave);
        });
        abandoned_grave = ModBlocks.register(event, (Block)new BlockAbandonedGrave());
        dark_marble = ModBlocks.register(event, new BlockGraveMarble(BlockGraveMarble.MarbleType.DARK, ModBlocks.getMarbleProperties("dark_marble")));
        white_marble = ModBlocks.register(event, new BlockGraveMarble(BlockGraveMarble.MarbleType.WHITE, ModBlocks.getMarbleProperties("white_marble")));
        blue_marble = ModBlocks.register(event, new BlockGraveMarble(BlockGraveMarble.MarbleType.BLUE, ModBlocks.getMarbleProperties("blue_marble")));
        green_marble = ModBlocks.register(event, new BlockGraveMarble(BlockGraveMarble.MarbleType.GREEN, ModBlocks.getMarbleProperties("green_marble")));
        carmin_marble = ModBlocks.register(event, new BlockGraveMarble(BlockGraveMarble.MarbleType.CARMIN, ModBlocks.getMarbleProperties("carmin_marble")));
        dark_marble_slab = ModBlocks.register(event, (Block)new SlabBlock(ModBlocks.getMarbleProperties("dark_marble_slab")));
        white_marble_slab = ModBlocks.register(event, (Block)new SlabBlock(ModBlocks.getMarbleProperties("white_marble_slab")));
        blue_marble_slab = ModBlocks.register(event, (Block)new SlabBlock(ModBlocks.getMarbleProperties("blue_marble_slab")));
        green_marble_slab = ModBlocks.register(event, (Block)new SlabBlock(ModBlocks.getMarbleProperties("green_marble_slab")));
        carmin_marble_slab = ModBlocks.register(event, (Block)new SlabBlock(ModBlocks.getMarbleProperties("carmin_marble_slab")));
        dark_marble_stairs = ModBlocks.register(event, (Block)new StairBlock(dark_marble.defaultBlockState(), ModBlocks.getMarbleProperties("dark_marble_stairs")));
        white_marble_stairs = ModBlocks.register(event, (Block)new StairBlock(white_marble.defaultBlockState(), ModBlocks.getMarbleProperties("white_marble_stairs")));
        blue_marble_stairs = ModBlocks.register(event, (Block)new StairBlock(blue_marble.defaultBlockState(), ModBlocks.getMarbleProperties("blue_marble_stairs")));
        green_marble_stairs = ModBlocks.register(event, (Block)new StairBlock(green_marble.defaultBlockState(), ModBlocks.getMarbleProperties("green_marble_stairs")));
        carmin_marble_stairs = ModBlocks.register(event, (Block)new StairBlock(carmin_marble.defaultBlockState(), ModBlocks.getMarbleProperties("carmin_marble_stairs")));
        dark_marble_wall = ModBlocks.register(event, (Block)new WallBlock(ModBlocks.getMarbleProperties("dark_marble_wall")));
        white_marble_wall = ModBlocks.register(event, (Block)new WallBlock(ModBlocks.getMarbleProperties("white_marble_wall")));
        blue_marble_wall = ModBlocks.register(event, (Block)new WallBlock(ModBlocks.getMarbleProperties("blue_marble_wall")));
        green_marble_wall = ModBlocks.register(event, (Block)new WallBlock(ModBlocks.getMarbleProperties("green_marble_wall")));
        carmin_marble_wall = ModBlocks.register(event, (Block)new WallBlock(ModBlocks.getMarbleProperties("carmin_marble_wall")));
        thornveil = ModBlocks.register(event, (Block)new FlowerBlock(ModEffects.true_sight, 4.0f, BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"thornveil"))).mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)){

            protected boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
                return state.is(ModTags.Blocks.non_sturdy_placable_surfaces) || state.isFaceSturdy(worldIn, pos, Direction.UP);
            }
        });
    }

    static void onRegisterBlockItems(RegisterEvent event) {
        DECORATIVE_GRAVES.forEach((key, value) -> ModBlocks.registerDecorativeGraveBlockItem(event, value));
        ModBlocks.registerGraveMarbleBlockItem(event, dark_marble);
        ModBlocks.registerGraveMarbleBlockItem(event, white_marble);
        ModBlocks.registerGraveMarbleBlockItem(event, blue_marble);
        ModBlocks.registerGraveMarbleBlockItem(event, green_marble);
        ModBlocks.registerGraveMarbleBlockItem(event, carmin_marble);
        ModBlocks.registerGraveMarbleBlockItem(event, dark_marble_slab);
        ModBlocks.registerGraveMarbleBlockItem(event, white_marble_slab);
        ModBlocks.registerGraveMarbleBlockItem(event, blue_marble_slab);
        ModBlocks.registerGraveMarbleBlockItem(event, green_marble_slab);
        ModBlocks.registerGraveMarbleBlockItem(event, carmin_marble_slab);
        ModBlocks.registerGraveMarbleBlockItem(event, dark_marble_stairs);
        ModBlocks.registerGraveMarbleBlockItem(event, white_marble_stairs);
        ModBlocks.registerGraveMarbleBlockItem(event, blue_marble_stairs);
        ModBlocks.registerGraveMarbleBlockItem(event, green_marble_stairs);
        ModBlocks.registerGraveMarbleBlockItem(event, carmin_marble_stairs);
        ModBlocks.registerGraveMarbleBlockItem(event, dark_marble_wall);
        ModBlocks.registerGraveMarbleBlockItem(event, white_marble_wall);
        ModBlocks.registerGraveMarbleBlockItem(event, blue_marble_wall);
        ModBlocks.registerGraveMarbleBlockItem(event, green_marble_wall);
        ModBlocks.registerGraveMarbleBlockItem(event, carmin_marble_wall);
        ModBlocks.registerBlockItem(event, thornveil);
    }

    private static void registerGraveMarbleBlockItem(RegisterEvent event, Block block) {
        ResourceKey rk = Objects.requireNonNull(block.properties().id);
        event.register(Registries.ITEM, rk.location(), () -> new ItemBlockGraveMarble(block, new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rk.location()))));
    }

    private static void registerDecorativeGraveBlockItem(RegisterEvent event, Block decorativeGrave) {
        ResourceKey rk = Objects.requireNonNull(decorativeGrave.properties().id);
        event.register(Registries.ITEM, rk.location(), () -> new ItemBlockGrave(decorativeGrave, new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rk.location()))));
    }

    private static void registerBlockItem(RegisterEvent event, Block block) {
        ResourceKey rk = Objects.requireNonNull(block.properties().id);
        event.register(Registries.ITEM, rk.location(), () -> new BlockItem(block, new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rk.location()))));
    }

    static void onRegisterBlockTypes(RegisterEvent event) {
        ModBlocks.register(BlockDecorativeGrave.CODEC, "decorative_grave");
        ModBlocks.register(BlockGrave.CODEC, "player_grave");
    }

    static void onRegisterBlockEntityTypes(RegisterEvent event) {
        tile_decorative_grave = new BlockEntityType(BlockEntityDecorativeGrave::new, DECORATIVE_GRAVES.values().toArray(new Block[0]));
        ModBlocks.register(event, tile_decorative_grave, "tile_decorative_grave");
        tile_grave = new BlockEntityType(BlockEntityPlayerGrave::new, PLAYER_GRAVES.values().toArray(new Block[0]));
        ModBlocks.register(event, tile_grave, "tile_grave");
    }

    private static BlockBehaviour.Properties getMarbleProperties(String name) {
        return BlockGraveMarble.getBuilder().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name)));
    }

    private static Block register(RegisterEvent event, Block block) {
        event.register(Registries.BLOCK, Objects.requireNonNull(block.properties().id).location(), () -> block);
        return block;
    }

    private static void register(RegisterEvent event, BlockEntityType<?> blockEntityType, String name) {
        event.register(Registries.BLOCK_ENTITY_TYPE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), () -> blockEntityType);
    }

    private static void register(MapCodec<? extends Block> blockType, String name) {
        Registry.register((Registry)BuiltInRegistries.BLOCK_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), blockType);
    }
}

