/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public final class GraveGuardianArmorLayer<S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends HumanoidModel<S>>
extends RenderLayer<S, M> {
    private final A innerModel;
    private final A outerModel;
    private final EquipmentLayerRenderer equipmentLayerRenderer;
    private final BiFunction<EquipmentClientInfo.LayerType, EquipmentClientInfo.Layer, ResourceLocation> layerTextureLookup;
    private final TriFunction<ArmorTrim, EquipmentClientInfo.LayerType, ResourceKey<EquipmentAsset>, TextureAtlasSprite> trimSpriteLookup;

    public GraveGuardianArmorLayer(RenderLayerParent<S, M> parent, A innerModel, A outerModel, EntityRendererProvider.Context context) {
        super(parent);
        this.innerModel = innerModel;
        this.outerModel = outerModel;
        this.equipmentLayerRenderer = context.getEquipmentRenderer();
        this.layerTextureLookup = Util.memoize((layerType, layer) -> layer.getTextureLocation(layerType));
        this.trimSpriteLookup = Helper.memoize((armorTrim, layerType, equipmentAssetId) -> context.getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET).getSprite(this.textureId((ArmorTrim)armorTrim, (EquipmentClientInfo.LayerType)layerType, (ResourceKey<EquipmentAsset>)equipmentAssetId)));
    }

    private ResourceLocation textureId(ArmorTrim trim, EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> equipmentAssetId) {
        return ((TrimPattern)trim.pattern().value()).assetId().withPath(p_377681_ -> "trims/entity/" + layerType.getSerializedName() + "/" + p_377681_ + "_" + ((TrimMaterial)trim.material().value()).assets().assetId(equipmentAssetId).suffix());
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, S renderState, float p_117100_, float p_117101_) {
        this.renderArmorPiece(poseStack, bufferSource, ((HumanoidRenderState)renderState).chestEquipment, EquipmentSlot.CHEST, light, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(poseStack, bufferSource, ((HumanoidRenderState)renderState).legsEquipment, EquipmentSlot.LEGS, light, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(poseStack, bufferSource, ((HumanoidRenderState)renderState).feetEquipment, EquipmentSlot.FEET, light, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(poseStack, bufferSource, ((HumanoidRenderState)renderState).headEquipment, EquipmentSlot.HEAD, light, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private static boolean shouldRender(Equippable equippable, EquipmentSlot slot) {
        return equippable.assetId().isPresent() && equippable.slot() == slot;
    }

    private A getArmorModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS ? this.innerModel : this.outerModel;
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, ItemStack stack, EquipmentSlot slot, int light, A model) {
        Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
        if (equippable != null && GraveGuardianArmorLayer.shouldRender(equippable, slot)) {
            ((HumanoidModel)this.getParentModel()).copyPropertiesTo(model);
            model.setAllVisible(true);
            ((HumanoidModel)model).head.visible = TimeHelper.getSpecialEvent() == TimeHelper.SpecialEvent.NONE || TimeHelper.isDateAroundSpringBloom();
            ResourceKey rk = (ResourceKey)equippable.assetId().orElseThrow();
            EquipmentClientInfo.LayerType layerType = slot == EquipmentSlot.LEGS ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
            try {
                model = (HumanoidModel)IClientItemExtensions.of((ItemStack)stack).getGenericArmorModel(stack, layerType, model);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            List equipementModelLayers = this.equipmentLayerRenderer.equipmentAssets.get(rk).getLayers(layerType);
            if (!equipementModelLayers.isEmpty()) {
                float b;
                float g;
                float r;
                boolean hasFoil = false;
                if (TimeHelper.isDateAroundHalloween()) {
                    r = 1.0f;
                    g = 0.4f;
                    b = 0.0f;
                    light = 0xF000F0;
                } else if (TimeHelper.isDateAroundChristmas()) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                } else if (TimeHelper.isDateAroundSpringBloom()) {
                    r = 0.5f;
                    g = 1.0f;
                    b = 0.4f;
                } else {
                    r = 0.0f;
                    g = 1.0f;
                    b = 1.0f;
                }
                int armorLayerTintColor = Helper.convertColorToInt(1.0f, r, g, b);
                for (EquipmentClientInfo.Layer equipmentModelLayer : equipementModelLayers) {
                    ResourceLocation resourcelocation = this.layerTextureLookup.apply(layerType, equipmentModelLayer);
                    resourcelocation = ClientHooks.getArmorTexture((ItemStack)stack, (EquipmentClientInfo.LayerType)layerType, (EquipmentClientInfo.Layer)equipmentModelLayer, (ResourceLocation)resourcelocation);
                    VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferSource, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)resourcelocation), (boolean)hasFoil);
                    model.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, armorLayerTintColor);
                }
                ArmorTrim armorTrim = this.getArmorTrim();
                if (armorTrim != null) {
                    this.renderTrim(poseStack, bufferSource, light, armorTrim, model, layerType, (ResourceKey<EquipmentAsset>)rk);
                }
            }
        }
    }

    @Nullable
    private ArmorTrim getArmorTrim() {
        RegistryAccess registryAccess = Optional.ofNullable(Minecraft.getInstance().level).map(Level::registryAccess).orElse(null);
        if (registryAccess != null) {
            ResourceKey trimMaterialRK;
            return new ArmorTrim((Holder)registryAccess.lookupOrThrow(Registries.TRIM_MATERIAL).getOrThrow(trimMaterialRK), (Holder)registryAccess.lookupOrThrow(Registries.TRIM_PATTERN).getOrThrow(switch (TimeHelper.getSpecialEvent()) {
                case TimeHelper.SpecialEvent.CHRISTMAS -> {
                    trimMaterialRK = TrimMaterials.QUARTZ;
                    yield TrimPatterns.DUNE;
                }
                case TimeHelper.SpecialEvent.HALLOWEEN -> {
                    trimMaterialRK = TrimMaterials.COPPER;
                    yield TrimPatterns.SILENCE;
                }
                case TimeHelper.SpecialEvent.SPRING_BLOOM -> {
                    trimMaterialRK = TrimMaterials.GOLD;
                    yield TrimPatterns.COAST;
                }
                default -> {
                    trimMaterialRK = TrimMaterials.GOLD;
                    yield TrimPatterns.WARD;
                }
            }));
        }
        return null;
    }

    private void renderTrim(PoseStack poseStack, MultiBufferSource bufferSource, int light, ArmorTrim armorTrim, A model, EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> rk) {
        TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)this.trimSpriteLookup.apply((Object)armorTrim, (Object)layerType, rk);
        VertexConsumer vertexConsumer = textureAtlasSprite.wrap(bufferSource.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)armorTrim.pattern().value()).decal())));
        model.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }
}

