/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.render.GraveGuardianCapeModel;
import ovh.corail.tombstone.render.GraveGuardianRenderState;

public class GraveGuardianCapeLayer
extends RenderLayer<GraveGuardianRenderState, SkeletonModel<GraveGuardianRenderState>> {
    private static final ResourceLocation CAPE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/block/cape.png");
    private final HumanoidModel<GraveGuardianRenderState> model;
    private final EquipmentAssetManager equipmentAssetManager;

    public GraveGuardianCapeLayer(RenderLayerParent<GraveGuardianRenderState, SkeletonModel<GraveGuardianRenderState>> parent, EntityModelSet entityModelSet, EquipmentAssetManager equipmentAssetManager) {
        super(parent);
        this.model = new GraveGuardianCapeModel(entityModelSet.bakeLayer(ModelLayers.PLAYER_CAPE));
        this.equipmentAssetManager = equipmentAssetManager;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GraveGuardianRenderState renderState, float p_116619_, float p_116620_) {
        if (!renderState.isInvisible) {
            float b;
            float g;
            float r;
            poseStack.pushPose();
            if (this.hasLayer(renderState.chestEquipment, EquipmentClientInfo.LayerType.HUMANOID)) {
                poseStack.translate(0.0f, -0.053125f, 0.06875f);
            }
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)this.getCloakTextureLocation()));
            ((SkeletonModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.setupAnim((HumanoidRenderState)renderState);
            if (TimeHelper.isDateAroundSpringBloom()) {
                r = 0.45f;
                g = 0.28f;
                b = 0.58f;
            } else if (TimeHelper.isDateAroundChristmas()) {
                r = 0.9f;
                g = 0.0f;
                b = 0.0f;
            } else if (TimeHelper.isDateAroundHalloween()) {
                r = 1.0f;
                g = 0.58f;
                b = 0.0f;
            } else {
                r = 0.0f;
                g = 0.41f;
                b = 0.45f;
            }
            this.model.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, Helper.convertColorToInt(1.0f, r, g, b));
            poseStack.popPose();
        }
    }

    private boolean hasLayer(ItemStack stack, EquipmentClientInfo.LayerType layerType) {
        Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
        if (equippable != null && equippable.assetId().isPresent()) {
            EquipmentClientInfo equipmentclientinfo = this.equipmentAssetManager.get((ResourceKey)equippable.assetId().get());
            return !equipmentclientinfo.getLayers(layerType).isEmpty();
        }
        return false;
    }

    private ResourceLocation getCloakTextureLocation() {
        return CAPE_TEXTURE;
    }
}

