/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.SkeletonRenderState;
import org.joml.Quaternionf;
import ovh.corail.tombstone.render.GraveGuardianRenderState;

public class GraveGuardianCapeModel
extends SkeletonModel<GraveGuardianRenderState> {
    private final ModelPart cape;

    public GraveGuardianCapeModel(ModelPart modelPart) {
        super(modelPart);
        this.cape = this.body.getChild("cape");
    }

    public static LayerDefinition createCapeLayer() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition rootPart = meshDefinition.getRoot();
        PartDefinition headPart = rootPart.clearChild("head");
        headPart.clearChild("hat");
        PartDefinition bodyPart = rootPart.clearChild("body");
        rootPart.clearChild("left_arm");
        rootPart.clearChild("right_arm");
        rootPart.clearChild("left_leg");
        rootPart.clearChild("right_leg");
        bodyPart.addOrReplaceChild("cape", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, CubeDeformation.NONE, 1.0f, 0.5f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(GraveGuardianRenderState renderState) {
        super.setupAnim((SkeletonRenderState)renderState);
        this.cape.rotateBy(new Quaternionf().rotateY((float)(-Math.PI)).rotateX((6.0f + renderState.capeLean / 2.0f + renderState.capeFlap) * ((float)Math.PI / 180)).rotateZ(renderState.capeLean2 / 2.0f * ((float)Math.PI / 180)).rotateY((180.0f - renderState.capeLean2 / 2.0f) * ((float)Math.PI / 180)));
    }
}

