/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SkeletonClothingLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.render.GraveGuardianArmorLayer;
import ovh.corail.tombstone.render.GraveGuardianCapeLayer;
import ovh.corail.tombstone.render.GraveGuardianRenderState;

public final class GraveGuardianRenderer
extends HumanoidMobRenderer<GraveGuardian, GraveGuardianRenderState, SkeletonModel<GraveGuardianRenderState>> {
    private static final ResourceLocation SKELETON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/stray.png");
    private static final ResourceLocation STRAY_CLOTHES_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/stray_overlay.png");
    private static final Supplier<ItemStack> HALLOWEEN_HELMET = Suppliers.memoize(() -> new ItemStack((ItemLike)Items.JACK_O_LANTERN));
    private static final Supplier<ItemStack> CHRISTMAS_HELMET = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.christmas_hat));
    private static final Supplier<ItemStack> HALLOWEEN_MAINHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)Items.GOLDEN_SHOVEL));
    private static final Supplier<ItemStack> CHRISTMAS_MAINHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.villager_gift));
    private static final Supplier<ItemStack> SPRING_BLOOM_MAINHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)Items.GOLDEN_HOE));
    private static final Supplier<ItemStack> DEFAULT_MAINHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)Items.NETHERITE_SWORD));
    private static final Supplier<ItemStack> HALLOWEEN_OFFHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.advancement.get((Object)ItemAdvancement.IconType.LANTERN)));
    private static final Supplier<ItemStack> CHRISTMAS_OFFHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.christmas_gift));
    private static final Supplier<ItemStack> SPRING_BLOOM_OFFHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)ModBlocks.thornveil));
    private static final Supplier<ItemStack> DEFAULT_OFFHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.advancement.get((Object)ItemAdvancement.IconType.SOUL_LANTERN)));

    public GraveGuardianRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new SkeletonModel(context.bakeLayer(ModelLayers.STRAY)), 0.5f);
        this.addLayer(new GraveGuardianArmorLayer(this, new SkeletonModel(context.bakeLayer(ModelLayers.STRAY_INNER_ARMOR)), new SkeletonModel(context.bakeLayer(ModelLayers.STRAY_OUTER_ARMOR)), context));
        this.addLayer((RenderLayer)new SkeletonClothingLayer((RenderLayerParent)this, context.getModelSet(), ModelLayers.STRAY_OUTER_LAYER, STRAY_CLOTHES_LOCATION));
        this.addLayer(new GraveGuardianCapeLayer((RenderLayerParent<GraveGuardianRenderState, SkeletonModel<GraveGuardianRenderState>>)this, context.getModelSet(), context.getEquipmentAssets()));
    }

    public ResourceLocation getTextureLocation(GraveGuardianRenderState renderState) {
        return SKELETON_LOCATION;
    }

    public GraveGuardianRenderState createRenderState() {
        return new GraveGuardianRenderState();
    }

    public void extractRenderState(GraveGuardian graveGuardian, GraveGuardianRenderState renderState, float partialTicks) {
        super.extractRenderState((Mob)graveGuardian, (HumanoidRenderState)renderState, partialTicks);
        this.itemModelResolver.updateForLiving(renderState.rightHandItem, this.getMainHand(), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (LivingEntity)graveGuardian);
        this.itemModelResolver.updateForLiving(renderState.leftHandItem, this.getOffHand(), ItemDisplayContext.THIRD_PERSON_LEFT_HAND, (LivingEntity)graveGuardian);
        renderState.headEquipment = this.getSpecialHelmet();
        this.itemModelResolver.updateForLiving(renderState.headItem, renderState.headEquipment, ItemDisplayContext.HEAD, (LivingEntity)graveGuardian);
        renderState.chestEquipment = graveGuardian.getItemBySlot(EquipmentSlot.CHEST).copy();
        renderState.legsEquipment = graveGuardian.getItemBySlot(EquipmentSlot.LEGS).copy();
        renderState.feetEquipment = graveGuardian.getItemBySlot(EquipmentSlot.FEET).copy();
        GraveGuardianRenderer.extractCapeState(graveGuardian, renderState, partialTicks);
    }

    private static void extractCapeState(GraveGuardian graveGuardian, GraveGuardianRenderState renderState, float partialTicks) {
        double d0 = Mth.lerp((double)partialTicks, (double)graveGuardian.xCloakO, (double)graveGuardian.xCloak) - Mth.lerp((double)partialTicks, (double)graveGuardian.xo, (double)graveGuardian.getX());
        double d1 = Mth.lerp((double)partialTicks, (double)graveGuardian.yCloakO, (double)graveGuardian.yCloak) - Mth.lerp((double)partialTicks, (double)graveGuardian.yo, (double)graveGuardian.getY());
        double d2 = Mth.lerp((double)partialTicks, (double)graveGuardian.zCloakO, (double)graveGuardian.zCloak) - Mth.lerp((double)partialTicks, (double)graveGuardian.zo, (double)graveGuardian.getZ());
        float f = Mth.rotLerp((float)partialTicks, (float)graveGuardian.yBodyRotO, (float)graveGuardian.yBodyRot);
        double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
        renderState.capeFlap = (float)d1 * 10.0f;
        renderState.capeFlap = Mth.clamp((float)renderState.capeFlap, (float)-6.0f, (float)32.0f);
        renderState.capeLean = (float)(d0 * d3 + d2 * d4) * 100.0f;
        renderState.capeLean = Mth.clamp((float)renderState.capeLean, (float)0.0f, (float)150.0f);
        renderState.capeLean2 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        renderState.capeLean2 = Mth.clamp((float)renderState.capeLean2, (float)-20.0f, (float)20.0f);
        float f1 = Mth.lerp((float)partialTicks, (float)graveGuardian.oBob, (float)graveGuardian.bob);
        float f2 = 0.0f;
        renderState.capeFlap += Mth.sin((float)(f2 * 6.0f)) * 32.0f * f1;
    }

    private ItemStack getMainHand() {
        return (TimeHelper.isDateAroundHalloween() ? HALLOWEEN_MAINHAND : (TimeHelper.isDateAroundChristmas() ? CHRISTMAS_MAINHAND : (TimeHelper.isDateAroundSpringBloom() ? SPRING_BLOOM_MAINHAND : DEFAULT_MAINHAND))).get();
    }

    private ItemStack getOffHand() {
        return (TimeHelper.isDateAroundHalloween() ? HALLOWEEN_OFFHAND : (TimeHelper.isDateAroundChristmas() ? CHRISTMAS_OFFHAND : (TimeHelper.isDateAroundSpringBloom() ? SPRING_BLOOM_OFFHAND : DEFAULT_OFFHAND))).get();
    }

    private ItemStack getSpecialHelmet() {
        return TimeHelper.isDateAroundHalloween() ? HALLOWEEN_HELMET.get() : (TimeHelper.isDateAroundChristmas() ? CHRISTMAS_HELMET.get() : ItemStack.EMPTY);
    }
}

