/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EvokerFangsModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.EvokerFangsRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;
import ovh.corail.tombstone.entity.SpectralBite;
import ovh.corail.tombstone.helper.Helper;

public final class SpectralBiteRenderer
extends EntityRenderer<SpectralBite, EvokerFangsRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/evoker_fangs.png");
    private final EvokerFangsModel model;

    public SpectralBiteRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new EvokerFangsModel(context.bakeLayer(ModelLayers.EVOKER_FANGS));
    }

    public void render(EvokerFangsRenderState evokerFangsRenderState, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        float progress = evokerFangsRenderState.biteProgress;
        if (progress != 0.0f) {
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f - evokerFangsRenderState.yRot));
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(0.0f, -1.501f, 0.0f);
            this.model.setupAnim(evokerFangsRenderState);
            this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURE_LOCATION)), 0xF000F0, OverlayTexture.NO_OVERLAY, Helper.convertColorToInt(0.3f, 0.5f, 1.0f, 1.0f));
            poseStack.popPose();
            super.render((EntityRenderState)evokerFangsRenderState, poseStack, bufferSource, light);
        }
    }

    public EvokerFangsRenderState createRenderState() {
        return new EvokerFangsRenderState();
    }

    public void extractRenderState(SpectralBite spectralBite, EvokerFangsRenderState evokerFangsRenderState, float partialTicks) {
        super.extractRenderState((Entity)spectralBite, (EntityRenderState)evokerFangsRenderState, partialTicks);
        evokerFangsRenderState.yRot = spectralBite.getYRot();
        evokerFangsRenderState.biteProgress = spectralBite.getAnimationProgress(partialTicks);
    }
}

