/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.util.Mth;

public class SpectralWolfModel
extends EntityModel<WolfRenderState> {
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart upperBody;

    public SpectralWolfModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.realHead = this.head.getChild("real_head");
        this.body = root.getChild("body");
        this.upperBody = root.getChild("upper_body");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.tail = root.getChild("tail");
        this.realTail = this.tail.getChild("real_tail");
    }

    public void setupAnim(WolfRenderState renderState) {
        super.setupAnim((EntityRenderState)renderState);
        float walkAnimationPos = renderState.walkAnimationPos;
        float walkAnimationSpeed = renderState.walkAnimationSpeed;
        this.tail.yRot = Mth.cos((float)(walkAnimationPos * 0.6662f)) * 1.4f * walkAnimationSpeed;
        this.rightHindLeg.xRot = Mth.cos((float)(walkAnimationPos * 0.6662f)) * 1.4f * walkAnimationSpeed;
        this.leftHindLeg.xRot = Mth.cos((float)(walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * walkAnimationSpeed;
        this.rightFrontLeg.xRot = Mth.cos((float)(walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * walkAnimationSpeed;
        this.leftFrontLeg.xRot = Mth.cos((float)(walkAnimationPos * 0.6662f)) * 1.4f * walkAnimationSpeed;
        this.realHead.zRot = renderState.headRollAngle + renderState.getBodyRollAngle(0.0f);
        this.upperBody.zRot = renderState.getBodyRollAngle(-0.08f);
        this.body.zRot = renderState.getBodyRollAngle(-0.16f);
        this.realTail.zRot = renderState.getBodyRollAngle(-0.2f);
        this.head.xRot = renderState.xRot * ((float)Math.PI / 180);
        this.head.yRot = renderState.yRot * ((float)Math.PI / 180);
        this.tail.xRot = renderState.tailAngle;
    }
}

