/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.common.NeoForge;
import ovh.corail.tombstone.entity.SpectralWolf;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.render.SpectralWolfModel;

public class SpectralWolfRenderer
extends MobRenderer<SpectralWolf, WolfRenderState, SpectralWolfModel> {
    private static final ResourceLocation WOLF_ANGRY_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/wolf/wolf_angry.png");

    public SpectralWolfRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SpectralWolfModel(context.bakeLayer(ModelLayers.WOLF)), 0.5f);
    }

    public ResourceLocation getTextureLocation(WolfRenderState spectralWolf) {
        return WOLF_ANGRY_LOCATION;
    }

    public WolfRenderState createRenderState() {
        return new WolfRenderState();
    }

    public void extractRenderState(SpectralWolf spectralWolf, WolfRenderState renderState, float partialTicks) {
        super.extractRenderState((LivingEntity)spectralWolf, (LivingEntityRenderState)renderState, partialTicks);
        renderState.isAngry = false;
        renderState.isSitting = false;
        renderState.tailAngle = spectralWolf.getTailAngle();
        renderState.headRollAngle = 0.0f;
        renderState.shakeAnim = 0.0f;
        renderState.texture = WOLF_ANGRY_LOCATION;
        renderState.wetShade = 1.0f;
        renderState.collarColor = null;
        renderState.bodyArmorItem = spectralWolf.getBodyArmorItem().copy();
    }

    public void render(WolfRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        RenderNameTagEvent.DoRender event;
        Direction direction;
        if (((RenderLivingEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntityRenderState)renderState, (LivingEntityRenderer)this, renderState.partialTick, poseStack, bufferSource, light))).isCanceled()) {
            return;
        }
        poseStack.pushPose();
        if (renderState.hasPose(Pose.SLEEPING) && (direction = renderState.bedOrientation) != null) {
            float eyeHeight = renderState.eyeHeight - 0.1f;
            poseStack.translate((float)(-direction.getStepX()) * eyeHeight, 0.0f, (float)(-direction.getStepZ()) * eyeHeight);
        }
        float scale = renderState.scale;
        poseStack.scale(scale, scale, scale);
        this.setupRotations((LivingEntityRenderState)renderState, poseStack, renderState.bodyRot, scale);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntityRenderState)renderState, poseStack);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        ((SpectralWolfModel)this.model).setupAnim(renderState);
        boolean isBodyVisible = this.isBodyVisible((LivingEntityRenderState)renderState);
        boolean isVisible = !isBodyVisible && !renderState.isInvisibleToPlayer;
        RenderType rendertype = this.getRenderType((LivingEntityRenderState)renderState, isBodyVisible, isVisible, renderState.appearsGlowing);
        if (rendertype != null) {
            ((SpectralWolfModel)this.model).renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)WOLF_ANGRY_LOCATION)), 0xF000F0, OverlayTexture.NO_OVERLAY, Helper.convertColorToInt(0.5f, 0.2f, 1.0f, 1.0f));
        }
        if (this.shouldRenderLayers((LivingEntityRenderState)renderState)) {
            for (RenderLayer renderlayer : this.layers) {
                renderlayer.render(poseStack, bufferSource, light, (EntityRenderState)renderState, renderState.yRot, renderState.xRot);
            }
        }
        poseStack.popPose();
        if (renderState.nameTag != null && !((RenderNameTagEvent.DoRender)NeoForge.EVENT_BUS.post((Event)(event = new RenderNameTagEvent.DoRender((EntityRenderState)renderState, renderState.nameTag, (EntityRenderer)this, poseStack, bufferSource, light, renderState.partialTick)))).isCanceled()) {
            this.renderNameTag((EntityRenderState)renderState, renderState.nameTag, poseStack, bufferSource, light);
        }
        NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntityRenderState)renderState, (LivingEntityRenderer)this, renderState.partialTick, poseStack, bufferSource, light));
    }
}

