/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.core.GameContext;
import nx.pingwheel.common.math.Raycast;
import nx.pingwheel.common.network.PingLocationC2SPacket;
import nx.pingwheel.common.platform.IPlatformNetworkService;

public class PingController {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private static boolean pingQueued = false;
    private static int pingSequence = 0;
    private static int lastPing = 0;

    private PingController() {
    }

    public static void revokePingAction() {
        pingQueued = false;
    }

    public static void queuePingAction() {
        pingQueued = true;
    }

    public static void pollPingAction(float tickDelta) {
        if (!pingQueued || CommonClient.Game.level == null) {
            return;
        }
        int time = (int)CommonClient.Game.level.getGameTime();
        if (CLIENT_CONFIG.getCorrectionPeriod() < 5.0f && (float)(time - lastPing) > CLIENT_CONFIG.getCorrectionPeriod() * 20.0f) {
            ++pingSequence;
        }
        lastPing = time;
        pingQueued = false;
        PingController.performPingAction(tickDelta);
    }

    private static void performPingAction(float tickDelta) {
        Entity cameraEntity = CommonClient.Game.cameraEntity;
        if (cameraEntity == null || CommonClient.Game.level == null) {
            return;
        }
        Vec3 cameraDirection = cameraEntity.getViewVector(tickDelta);
        HitResult hitResult = Raycast.traceDirectional(cameraDirection, tickDelta, Math.min(CLIENT_CONFIG.getRaycastDistance(), CLIENT_CONFIG.getPingDistance()), cameraEntity.isCrouching());
        if (hitResult == null || hitResult.getType() == HitResult.Type.MISS) {
            if (CommonClient.DistantHorizonsLoaded) {
                Raycast.traceDistantAsync(cameraDirection, tickDelta, distantHitResult -> IPlatformNetworkService.INSTANCE.sendToServer(new PingLocationC2SPacket(CLIENT_CONFIG.getChannel(), distantHitResult.getLocation(), null, pingSequence, GameContext.getDimension())));
            }
            return;
        }
        UUID uuid = null;
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            uuid = ((EntityHitResult)hitResult).getEntity().getUUID();
        }
        IPlatformNetworkService.INSTANCE.sendToServer(new PingLocationC2SPacket(CLIENT_CONFIG.getChannel(), hitResult.getLocation(), uuid, pingSequence, GameContext.getDimension()));
    }

    public static boolean isPingQueued() {
        return pingQueued;
    }
}

