/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.resource;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class LanguageUtils {
    public static final MutableComponent SYMBOL_INFINITE = Component.translatable((String)"ping-wheel.symbol.infinite");
    public static final MutableComponent VALUE_HIDDEN = Component.translatable((String)"ping-wheel.value.hidden");
    public static final MutableComponent NEWLINE = Component.literal((String)"\n");
    public static final LanguageWrapper UNIT_SECONDS = new LanguageWrapper("ping-wheel.unit.seconds");
    public static final LanguageWrapper UNIT_METERS = new LanguageWrapper("ping-wheel.unit.meters");
    public static final LanguageWrapper UNIT_PERCENT = new LanguageWrapper("ping-wheel.unit.percent");

    private LanguageUtils() {
    }

    public static LanguageWrapper settings(String key) {
        return new LanguageWrapper("ping-wheel.settings." + key);
    }

    public static LanguageWrapper command(String key) {
        return new LanguageWrapper("ping-wheel.command." + key);
    }

    public static MutableComponent join(MutableComponent ... components) {
        MutableComponent output = Component.empty();
        for (int i = 0; i < components.length; ++i) {
            MutableComponent component = components[i];
            if (i > 0) {
                output.append((Component)NEWLINE);
            }
            output.append((Component)component);
        }
        return output;
    }

    public static MutableComponent wrapped(MutableComponent component) {
        return Component.empty().append((Component)Component.literal((String)"(")).append((Component)component).append((Component)Component.literal((String)")"));
    }

    public static MutableComponent withModPrefix(MutableComponent component) {
        return Component.empty().append((Component)Component.literal((String)"[Ping-Wheel] ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)component);
    }

    public static MutableComponent from(Object any) {
        return Component.literal((String)String.format("%s", any));
    }

    public record LanguageWrapper(String key) {
        public LanguageWrapper path(String key) {
            return new LanguageWrapper(this.key + "." + key);
        }

        public MutableComponent get(Object ... args) {
            return Component.translatable((String)this.key, (Object[])args);
        }
    }
}

