/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.screen;

import java.util.List;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.screen.OptionUtils;

public class SettingsScreen
extends OptionsSubScreen {
    private final ClientConfig config = ClientConfig.HANDLER.getConfig();
    private Screen parent;
    private EditBox channelTextField;

    public SettingsScreen() {
        super(null, null, (Component)LanguageUtils.settings("title").get(new Object[0]));
    }

    public SettingsScreen(Screen parent) {
        this();
        this.parent = parent;
    }

    public void tick() {
        if (this.channelTextField.isFocused() && this.getFocused() != this.channelTextField) {
            this.setFocused((GuiEventListener)this.channelTextField);
        }
    }

    protected void init() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addContents() {
        this.list = (OptionsList)this.layout.addToContents((LayoutElement)new OptionsList(this.minecraft, this.width, (OptionsSubScreen)this));
        this.addOptions();
    }

    protected void addOptions() {
        OptionInstance<Integer> pingVolumeOption = this.getPingVolumeOption();
        OptionInstance<Integer> pingDurationOption = this.getPingDurationOption();
        this.list.addSmall(new OptionInstance[]{pingVolumeOption, pingDurationOption});
        OptionInstance<Integer> pingDistanceOption = this.getPingDistanceOption();
        OptionInstance<Float> correctionPeriodOption = this.getCorrectionPeriodOption();
        this.list.addSmall(new OptionInstance[]{pingDistanceOption, correctionPeriodOption});
        OptionInstance<Boolean> itemIconsVisibleOption = this.getItemIconsVisibleOption();
        OptionInstance<Boolean> directionIndicatorVisibleOption = this.getDirectionIndicatorVisibleOption();
        this.list.addSmall(new OptionInstance[]{itemIconsVisibleOption, directionIndicatorVisibleOption});
        OptionInstance<Boolean> nameLabelForcedOption = this.getNameLabelForcedOption();
        OptionInstance<Integer> pingSizeOption = this.getPingSizeOption();
        this.list.addSmall(new OptionInstance[]{nameLabelForcedOption, pingSizeOption});
        this.channelTextField = new EditBox(this.font, this.width / 2 - 100, 160, 200, 20, (Component)Component.empty());
        this.channelTextField.setMaxLength(128);
        this.channelTextField.setValue(this.config.getChannel());
        this.channelTextField.setResponder(this.config::setChannel);
        this.addWidget((GuiEventListener)this.channelTextField);
    }

    public void onClose() {
        ClientConfig.HANDLER.save();
        if (this.parent != null && this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        } else {
            super.onClose();
        }
    }

    public void render(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        super.render(ctx, mouseX, mouseY, delta);
        this.list.render(ctx, mouseX, mouseY, delta);
        this.channelTextField.setPosition(this.width / 2 - 100, 160);
        ctx.drawString(this.font, (Component)LanguageUtils.settings("channel").get(new Object[0]), this.width / 2 - 100, this.channelTextField.getY() - 12, 0xA0A0A0);
        this.channelTextField.render(ctx, mouseX, mouseY, delta);
        if (this.channelTextField.isHoveredOrFocused() && !this.channelTextField.isFocused()) {
            List<ClientTooltipComponent> clientTooltipComponentList = this.font.split((FormattedText)LanguageUtils.settings("channel.tooltip").get(new Object[0]), 140).stream().map(ClientTooltipComponent::create).toList();
            ctx.renderTooltip(this.font, clientTooltipComponentList, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null);
        }
    }

    private OptionInstance<Integer> getPingVolumeOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("pingVolume");
        return OptionUtils.ofInt(text.key(), 0, 100, 1, value -> {
            if (value == 0) {
                return text.get(CommonComponents.OPTION_OFF);
            }
            return text.get(LanguageUtils.UNIT_PERCENT.get(value));
        }, this.config::getPingVolume, this.config::setPingVolume);
    }

    private OptionInstance<Integer> getPingDurationOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("pingDuration");
        return OptionUtils.ofInt(text.key(), 1, 60, 1, value -> {
            if (value >= 60) {
                return text.get(LanguageUtils.SYMBOL_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get(value));
        }, this.config::getPingDuration, this.config::setPingDuration);
    }

    private OptionInstance<Integer> getPingDistanceOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("pingDistance");
        return OptionUtils.ofInt(text.key(), 0, 2048, 16, value -> {
            if (value == 0) {
                return text.get(LanguageUtils.VALUE_HIDDEN);
            }
            if (value >= 2048) {
                return text.get(LanguageUtils.SYMBOL_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_METERS.get(value));
        }, this.config::getPingDistance, this.config::setPingDistance);
    }

    private OptionInstance<Float> getCorrectionPeriodOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("correctionPeriod");
        return OptionUtils.ofFloat(text.key(), 0.1f, 5.0f, 0.1f, value -> {
            if (value.floatValue() >= 5.0f) {
                return text.get(LanguageUtils.SYMBOL_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get("%.1f".formatted(value)));
        }, this.config::getCorrectionPeriod, this.config::setCorrectionPeriod);
    }

    private OptionInstance<Boolean> getItemIconsVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("itemIconVisible").key(), this.config::isItemIconVisible, this.config::setItemIconVisible);
    }

    private OptionInstance<Boolean> getDirectionIndicatorVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("directionIndicatorVisible").key(), this.config::isDirectionIndicatorVisible, this.config::setDirectionIndicatorVisible);
    }

    private OptionInstance<Boolean> getNameLabelForcedOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("nameLabelForced").key(), this.config::isNameLabelForced, this.config::setNameLabelForced);
    }

    private OptionInstance<Integer> getPingSizeOption() {
        LanguageUtils.LanguageWrapper text = LanguageUtils.settings("pingSize");
        return OptionUtils.ofInt(text.key(), 40, 300, 10, value -> text.get(LanguageUtils.UNIT_PERCENT.get(value)), this.config::getPingSize, this.config::setPingSize);
    }
}

