/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.neoforge;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.command.ClientCommandBuilder;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.resource.ResourceReloadListener;
import nx.pingwheel.common.screen.SettingsScreen;

public class NeoClient {
    public static final ResourceLocation RELOAD_LISTENER_ID = ResourceLocation.fromNamespaceAndPath((String)"ping-wheel", (String)"reload-listener");

    public NeoClient(IEventBus modBus) {
        CommonClient.INSTANCE.onInit();
        NeoForge.EVENT_BUS.register((Object)this);
        modBus.addListener(event -> event.addListener(RELOAD_LISTENER_ID, (PreparableReloadListener)new ResourceReloadListener()));
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (a, parent) -> new SettingsScreen(parent));
    }

    @SubscribeEvent
    public void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register(ClientCommandBuilder.build((context, success, response) -> {
            if (success.booleanValue()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> LanguageUtils.withModPrefix(response), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)LanguageUtils.withModPrefix(response));
            }
        }));
    }
}

