/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen.element.button;

import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.network.to_server.UpdateDimChest;
import edivad.dimstorage.network.to_server.UpdateDimTank;
import edivad.dimstorage.setup.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class OwnerButton
extends AbstractButton {
    private final BlockEntityFrequencyOwner owner;

    public OwnerButton(int width, int height, BlockEntityFrequencyOwner owner) {
        super(width, height, 64, 20, OwnerButton.getText(owner));
        this.owner = owner;
        this.active = (Boolean)Config.DimBlock.ALLOW_PRIVATE_NETWORK.get();
    }

    private static Component getText(BlockEntityFrequencyOwner owner) {
        return Component.literal((String)owner.getFrequency().getOwner());
    }

    public void onPress() {
        this.owner.swapOwner((Player)Minecraft.getInstance().player);
        BlockEntityFrequencyOwner blockEntityFrequencyOwner = this.owner;
        if (blockEntityFrequencyOwner instanceof BlockEntityDimChest) {
            BlockEntityDimChest chest = (BlockEntityDimChest)blockEntityFrequencyOwner;
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new UpdateDimChest(chest), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            blockEntityFrequencyOwner = this.owner;
            if (blockEntityFrequencyOwner instanceof BlockEntityDimTank) {
                BlockEntityDimTank tank = (BlockEntityDimTank)blockEntityFrequencyOwner;
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new UpdateDimTank(tank), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

