/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen.pattern;

import edivad.dimstorage.client.screen.pattern.BaseScreen;
import edivad.dimstorage.setup.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PanelScreen<T extends AbstractContainerMenu>
extends BaseScreen<T> {
    private static final int ANIMATION_SPEED = 10;
    private static final int SETTINGS_WIDTH = 80;
    private static final int SETTINGS_HEIGHT = 180;
    private static final int BUTTON_WIDTH = 20;
    private final boolean allowConfig;
    private final List<AbstractWidget> component;
    protected boolean drawSettings;
    private SettingsState state;
    private int animationState;
    private boolean settingsButtonOver;

    public PanelScreen(T container, Inventory inventory, Component text, ResourceLocation background, boolean drawSettings) {
        super(container, inventory, text, background);
        this.drawSettings = drawSettings;
        this.settingsButtonOver = false;
        this.allowConfig = (Boolean)Config.DimBlock.ALLOW_CONFIG.get();
        this.component = new ArrayList<AbstractWidget>();
        if (this.drawSettings) {
            this.animationState = 80;
            this.state = SettingsState.STATE_OPENED;
        } else {
            this.animationState = 0;
            this.state = SettingsState.STATE_CLOSED;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.state == SettingsState.STATE_OPENING) {
            this.animationState += 10;
            if (this.animationState >= 80) {
                this.animationState = 80;
                this.state = SettingsState.STATE_OPENED;
                this.drawSettings(true);
            }
        } else if (this.state == SettingsState.STATE_CLOSING) {
            this.drawSettings(false);
            this.animationState -= 10;
            if (this.animationState <= 0) {
                this.animationState = 0;
                this.state = SettingsState.STATE_CLOSED;
            }
        }
    }

    private int getButtonX() {
        return this.leftPos + this.imageWidth;
    }

    private int getButtonY() {
        return this.topPos + 16;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        super.mouseClicked(mouseX, mouseY, clickedButton);
        if (this.allowConfig && mouseX >= (double)this.getButtonX() && mouseX <= (double)(this.getButtonX() + 20) && mouseY >= (double)this.getButtonY() && mouseY <= (double)(this.getButtonY() + 20)) {
            if (this.state == SettingsState.STATE_CLOSED) {
                this.state = SettingsState.STATE_OPENING;
            } else if (this.state == SettingsState.STATE_OPENED) {
                this.state = SettingsState.STATE_CLOSING;
            }
            return true;
        }
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        this.settingsButtonOver = false;
        if (mouseX >= (double)this.getButtonX() && mouseX <= (double)(this.getButtonX() + 20) && mouseY >= (double)this.getButtonY() && mouseY <= (double)(this.getButtonY() + 20)) {
            this.settingsButtonOver = true;
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int settingsX = this.leftPos + (this.imageWidth - 80);
        if (this.allowConfig) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.background, settingsX + this.animationState, this.topPos + 36, (float)this.imageWidth, 36.0f, 80, this.imageHeight, 256, 256);
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.background, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight + 2, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.background, this.getButtonX(), this.getButtonY(), (float)this.imageWidth, 16.0f, 20, 20, 256, 256);
        if (this.state == SettingsState.STATE_CLOSED || this.state == SettingsState.STATE_OPENING) {
            if (this.settingsButtonOver) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.background, this.getButtonX() + 6, this.getButtonY() - 3, (float)(this.imageWidth + 28), 16.0f, 8, 20, 256, 256);
            } else {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.background, this.getButtonX() + 6, this.getButtonY() - 3, (float)(this.imageWidth + 20), 16.0f, 8, 20, 256, 256);
            }
        } else if (this.state == SettingsState.STATE_OPENED || this.state == SettingsState.STATE_CLOSING) {
            if (this.settingsButtonOver) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.background, this.getButtonX() + 4, this.getButtonY() - 3, (float)(this.imageWidth + 44), 16.0f, 8, 20, 256, 256);
            } else {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.background, this.getButtonX() + 4, this.getButtonY() - 3, (float)(this.imageWidth + 36), 16.0f, 8, 20, 256, 256);
            }
        }
    }

    public List<Rect2i> getAreas() {
        return List.of(new Rect2i(this.leftPos + this.imageWidth, this.getButtonY(), 20, 20), new Rect2i(this.leftPos + this.imageWidth, this.getButtonY() + 20, this.animationState, 180));
    }

    protected void clearComponent() {
        this.component.clear();
    }

    protected void addComponent(AbstractWidget widget) {
        this.component.add(widget);
        this.addRenderableWidget((GuiEventListener)widget);
    }

    protected void drawSettings(boolean draw) {
        this.drawSettings = draw;
        for (AbstractWidget widget : this.component) {
            widget.visible = draw;
        }
    }

    private static enum SettingsState {
        STATE_CLOSED,
        STATE_OPENING,
        STATE_OPENED,
        STATE_CLOSING;

    }
}

