/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.datagen.models;

import edivad.dimstorage.blocks.DimChestBlock;
import edivad.dimstorage.blocks.DimTankBlock;
import edivad.dimstorage.datagen.models.DimStorageModelTemplates;
import edivad.dimstorage.setup.Registration;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;

public class DimStorageModelProvider
extends ModelProvider {
    public DimStorageModelProvider(PackOutput output) {
        super(output, "dimstorage");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        itemModels.generateFlatItem((Item)Registration.DIMWALL.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)Registration.DIMCORE.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)Registration.SOLIDDIMCORE.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)Registration.DIMTABLET.get(), ModelTemplates.FLAT_ITEM);
        this.createDimChest(blockModels, (DimChestBlock)((Object)Registration.DIMCHEST.get()));
        this.createDimTank(blockModels, (DimTankBlock)((Object)Registration.DIMTANK.get()));
    }

    private void createDimChest(BlockModelGenerators blockModels, DimChestBlock block) {
        TextureMapping tm = new TextureMapping().put(TextureSlot.DOWN, TextureMapping.getBlockTexture((Block)block, (String)"_bottom")).put(TextureSlot.UP, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.NORTH, TextureMapping.getBlockTexture((Block)block, (String)"_sides")).put(TextureSlot.SOUTH, TextureMapping.getBlockTexture((Block)block, (String)"_sides")).put(TextureSlot.EAST, TextureMapping.getBlockTexture((Block)block, (String)"_sides")).put(TextureSlot.WEST, TextureMapping.getBlockTexture((Block)block, (String)"_sides")).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)block, (String)"_top"));
        ResourceLocation model = ModelTemplates.CUBE.extend().transform(ItemDisplayContext.GUI, transformVecBuilder -> transformVecBuilder.rotation(25.0f, 45.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f)).build().create((Block)block, tm, blockModels.modelOutput);
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)model)));
        blockModels.registerSimpleItemModel((Block)block, model);
    }

    private void createDimTank(BlockModelGenerators blockModels, DimTankBlock block) {
        ResourceLocation model = DimStorageModelTemplates.DIM_TANK_TEMPLATE_PROVIDER.updateTemplate(modelTemplate -> modelTemplate.extend().renderType("cutout").build()).create((Block)block, blockModels.modelOutput);
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)model)));
        blockModels.registerSimpleItemModel((Block)block, model);
    }

    protected Stream<? extends Holder<Block>> getKnownBlocks() {
        return Stream.of(new Holder[0]);
    }

    protected Stream<? extends Holder<Item>> getKnownItems() {
        return Stream.of(new Holder[0]);
    }
}

