/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.manager;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import edivad.dimstorage.DimStorage;
import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.DimStoragePlugin;
import edivad.dimstorage.api.Frequency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.slf4j.Logger;

public class DimStorageManager
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SavedDataType<DimStorageManager> TYPE = new SavedDataType("dimstorage_inventories", DimStorageManager::new, ctx -> RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)ctx.levelOrThrow()), (App)CompoundTag.CODEC.fieldOf("tag").forGetter(DimStorageManager::getTag)).apply((Applicative)instance, DimStorageManager::new)));
    private static final HashMap<String, DimStoragePlugin> PLUGINS = new HashMap();
    private static DimStorageManager SERVER_MANAGER;
    private static DimStorageManager CLIENT_MANAGER;
    private final boolean client;
    private final Map<String, AbstractDimStorage> storageMap;
    private final Map<String, List<AbstractDimStorage>> storageList;
    private final List<AbstractDimStorage> dirtyStorage;
    private final Level level;
    private CompoundTag saveTag;

    private DimStorageManager(SavedData.Context ctx) {
        this((Level)ctx.level().getLevel());
    }

    private DimStorageManager(Level level) {
        this.level = level;
        this.client = level.isClientSide();
        this.saveTag = new CompoundTag();
        this.storageMap = Collections.synchronizedMap(new HashMap());
        this.storageList = Collections.synchronizedMap(new HashMap());
        this.dirtyStorage = Collections.synchronizedList(new LinkedList());
        for (String key : PLUGINS.keySet()) {
            this.storageList.put(key, new ArrayList());
        }
    }

    private DimStorageManager(ServerLevel serverLevel, CompoundTag compoundTag) {
        this((Level)serverLevel);
        this.saveTag = compoundTag.getCompound("inventory").orElse(new CompoundTag());
    }

    public static void reloadManager(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SERVER_MANAGER = DimStorageManager.get(serverLevel);
        } else {
            CLIENT_MANAGER = new DimStorageManager(level);
        }
    }

    public static DimStorageManager instance(Level level) {
        DimStorageManager manager;
        boolean client = level.isClientSide();
        DimStorageManager dimStorageManager = manager = client ? CLIENT_MANAGER : SERVER_MANAGER;
        if (manager == null) {
            DimStorageManager.reloadManager(level);
            manager = client ? CLIENT_MANAGER : SERVER_MANAGER;
        }
        return manager;
    }

    private static DimStorageManager get(ServerLevel level) {
        return (DimStorageManager)level.getDataStorage().computeIfAbsent(TYPE);
    }

    public static void registerPlugin(DimStoragePlugin plugin) {
        PLUGINS.put(plugin.identifier(), plugin);
        if (SERVER_MANAGER != null) {
            DimStorageManager.SERVER_MANAGER.storageList.put(plugin.identifier(), new ArrayList());
        }
        if (CLIENT_MANAGER != null) {
            DimStorageManager.CLIENT_MANAGER.storageList.put(plugin.identifier(), new ArrayList());
        }
    }

    public boolean isServer() {
        return !this.client;
    }

    private void sendClientInfo(Player player) {
        for (Map.Entry<String, DimStoragePlugin> plugin : PLUGINS.entrySet()) {
            plugin.getValue().sendClientInfo(player, this.storageList.get(plugin.getKey()));
        }
    }

    private CompoundTag getTag() {
        CompoundTag tag = new CompoundTag();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(() -> "DimStorageManager", LOGGER);){
            for (AbstractDimStorage inv : this.dirtyStorage) {
                TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.level.registryAccess());
                inv.serialize((ValueOutput)out);
                inv.setClean();
                this.saveTag.put(DimStorageManager.buildKey(inv.freq, inv.type()), (Tag)out.buildResult());
            }
            this.dirtyStorage.clear();
        }
        tag.put("inventory", (Tag)this.saveTag);
        return tag;
    }

    private static String buildKey(Frequency frequency, String type) {
        return String.valueOf(frequency) + ",type=" + type;
    }

    public AbstractDimStorage getStorage(Frequency freq, String type) {
        String key = DimStorageManager.buildKey(freq, type);
        AbstractDimStorage storage = this.storageMap.get(key);
        if (storage == null) {
            storage = PLUGINS.get(type).createDimStorage(this, freq);
            if (!this.client && this.saveTag.contains(key)) {
                try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(() -> "DimStorageManager", LOGGER);){
                    ValueInput in = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)((CompoundTag)this.saveTag.getCompound(key).orElseThrow()));
                    storage.deserialize(in);
                }
            }
            this.storageMap.put(key, storage);
            this.storageList.get(type).add(storage);
        }
        return storage;
    }

    public void requestSave(AbstractDimStorage storage) {
        this.dirtyStorage.add(storage);
        this.setDirty();
    }

    public static class DimStorageSaveHandler {
        @SubscribeEvent
        public void onWorldLoad(LevelEvent.Load event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof Level) {
                Level level = (Level)levelAccessor;
                DimStorageManager.reloadManager(level);
            } else {
                DimStorage.LOGGER.warn("Unable to reload the manager");
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            DimStorageManager.instance(event.getEntity().level()).sendClientInfo(event.getEntity());
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            DimStorageManager.instance(event.getEntity().level()).sendClientInfo(event.getEntity());
        }
    }
}

