/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.storage;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.network.to_client.OpenChest;
import edivad.dimstorage.tools.InventoryUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;

public class DimChestStorage
extends AbstractDimStorage
implements Container {
    private NonNullList<ItemStack> items;
    private int open;

    public DimChestStorage(DimStorageManager manager, Frequency freq) {
        super(manager, freq);
        this.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.empty();
            this.setDirty();
        }
    }

    public void deserialize(ValueInput input) {
        this.empty();
        ContainerHelper.loadAllItems((ValueInput)input, this.items);
    }

    @Override
    public String type() {
        return "item";
    }

    public void serialize(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output, this.items, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getItem(int slot) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return (ItemStack)this.items.get(slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack removeItemNoUpdate(int index) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return InventoryUtils.removeStackFromSlot(this, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(int slot, ItemStack stack) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.items.set(slot, (Object)stack);
            this.setChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory() {
        if (this.manager.isServer()) {
            DimChestStorage dimChestStorage = this;
            synchronized (dimChestStorage) {
                ++this.open;
                if (this.open >= 1) {
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new OpenChest(this.freq, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInventory() {
        if (this.manager.isServer()) {
            DimChestStorage dimChestStorage = this;
            synchronized (dimChestStorage) {
                --this.open;
                if (this.open <= 0) {
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new OpenChest(this.freq, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int getContainerSize() {
        return 54;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack removeItem(int slot, int size) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return InventoryUtils.decrStackSize(this, slot, size);
        }
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        this.setDirty();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void empty() {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
    }

    public void setClientOpen(int i) {
        if (!this.manager.isServer()) {
            this.open = i;
        }
    }

    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return true;
    }

    public void clearContent() {
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }
}

