/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.storage;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class DimTankStorage
extends AbstractDimStorage
implements IFluidHandler {
    public static final int CAPACITY = 16000;
    private Tank tank = new Tank(16000);

    public DimTankStorage(DimStorageManager manager, Frequency freq) {
        super(manager, freq);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluid().copy();
    }

    public int getTankCapacity(int tank) {
        return 16000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    @Override
    public void clearStorage() {
        this.tank = new Tank(16000);
        this.setDirty();
    }

    @Override
    public String type() {
        return "fluid";
    }

    public void serialize(ValueOutput output) {
        this.tank.serialize(output);
    }

    public void deserialize(ValueInput input) {
        this.tank.deserialize(input);
    }

    private class Tank
    extends FluidTank {
        public Tank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            DimTankStorage.this.setDirty();
        }
    }
}

