/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tools;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class InventoryUtils {
    public static ItemStack removeStackFromSlot(Container inv, int slot) {
        ItemStack stack = inv.getItem(slot);
        inv.setItem(slot, ItemStack.EMPTY);
        return stack;
    }

    @NotNull
    public static ItemStack decrStackSize(Container inv, int slot, int size) {
        ItemStack item = inv.getItem(slot);
        if (!item.isEmpty()) {
            if (item.getCount() <= size) {
                inv.setItem(slot, ItemStack.EMPTY);
                inv.setChanged();
                return item;
            }
            ItemStack itemstack1 = item.split(size);
            if (item.getCount() == 0) {
                inv.setItem(slot, ItemStack.EMPTY);
            } else {
                inv.setItem(slot, item);
            }
            inv.setChanged();
            return itemstack1;
        }
        return ItemStack.EMPTY;
    }

    public static boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, InvWrapper wrapper) {
        int i;
        boolean flag = false;
        if (stack.isStackable()) {
            for (i = startIndex; !stack.isEmpty() && i < endIndex; ++i) {
                int maxSize;
                ItemStack itemstack = wrapper.getStackInSlot(i);
                if (itemstack.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemstack)) continue;
                int j = itemstack.getCount() + stack.getCount();
                if (j <= (maxSize = stack.getMaxStackSize())) {
                    stack.setCount(0);
                    itemstack.setCount(j);
                    flag = true;
                    continue;
                }
                if (itemstack.getCount() >= maxSize) continue;
                stack.shrink(maxSize - itemstack.getCount());
                itemstack.setCount(maxSize);
                flag = true;
            }
        }
        if (!stack.isEmpty()) {
            for (i = startIndex; i < endIndex && !flag; ++i) {
                ItemStack itemstack1 = wrapper.getStackInSlot(i);
                if (!itemstack1.isEmpty() || !wrapper.isItemValid(i, stack)) continue;
                if (stack.getCount() > 64) {
                    wrapper.setStackInSlot(i, stack.split(64));
                } else {
                    wrapper.setStackInSlot(i, stack.split(stack.getCount()));
                }
                flag = true;
            }
        }
        return flag;
    }
}

