/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.tinyskeletons.client.renderer.entity.state.BabySkeletonRenderState;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Quaternionfc;

public class ItemOnBackLayer<M extends HumanoidModel<BabySkeletonRenderState>>
extends RenderLayer<BabySkeletonRenderState, M> {
    public ItemOnBackLayer(RenderLayerParent<BabySkeletonRenderState, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, BabySkeletonRenderState renderState, float yRot, float xRot) {
        ItemStackRenderState itemStackRenderState = BabySkeletonRenderState.getOffHandItem((HumanoidRenderState)renderState);
        if (!itemStackRenderState.isEmpty()) {
            float backOffset;
            poseStack.pushPose();
            ModelPart modelPart = ((HumanoidModel)this.getParentModel()).body;
            modelPart.translateAndRotate(poseStack);
            float scale = 2.0f;
            float f = backOffset = !renderState.chestEquipment.isEmpty() ? 0.24f : 0.18f;
            if (renderState.offhandItemType != BabySkeletonRenderState.ItemType.TRIDENT) {
                poseStack.translate(0.0, 0.0, (double)backOffset);
                poseStack.scale(scale, scale, scale);
                if (renderState.offhandItemType == BabySkeletonRenderState.ItemType.ROD) {
                    poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
                    poseStack.translate(0.0, -0.3, 0.0);
                }
            } else {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(52.0f));
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(40.0f));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-25.0f));
                poseStack.scale(scale *= 0.5f, -scale, -scale);
                poseStack.translate((double)(-backOffset), 0.0, 0.0);
            }
            itemStackRenderState.render(poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

