/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.tinyskeletons.client.renderer.entity.state.BabyWitherSkeletonRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class SkullInHandLayer<S extends BabyWitherSkeletonRenderState, M extends EntityModel<S>>
extends ItemInHandLayer<S, M> {
    private final BlockRenderDispatcher blockRenderer;

    public SkullInHandLayer(RenderLayerParent<S, M> renderLayerParent, BlockRenderDispatcher blockRenderer) {
        super(renderLayerParent);
        this.blockRenderer = blockRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, S renderState, float yRot, float xRot) {
        ItemStack itemStack = ((BabyWitherSkeletonRenderState)((Object)renderState)).skullItem;
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.renderHandSkullItem(blockItem.getBlock().defaultBlockState(), poseStack, bufferSource, packedLight);
        } else {
            super.render(poseStack, bufferSource, packedLight, renderState, yRot, xRot);
        }
    }

    private void renderHandSkullItem(BlockState blockState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.075f, 0.325f);
        poseStack.translate(0.0f, 0.6875f, -0.75f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(20.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        poseStack.translate(0.25f, 0.1875f, 0.25f);
        poseStack.scale(-0.5f, -0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        this.blockRenderer.renderSingleBlock(blockState, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

