/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.world.entity.monster;

import fuzs.puzzleslib.api.item.v2.ToolTypeHelper;
import fuzs.tinyskeletons.init.ModRegistry;
import fuzs.tinyskeletons.world.entity.ai.goal.RangedBowAttackWithoutStrafingGoal;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BabySkeleton
extends Skeleton {
    private int switchWeaponCooldown;

    public BabySkeleton(EntityType<? extends Skeleton> entityType, Level level) {
        super(entityType, level);
        this.xpReward = (int)((float)this.xpReward * 2.5f);
        this.refreshDimensions();
        this.bowGoal = new RangedBowAttackWithoutStrafingGoal<BabySkeleton>(this, 1.0, 30, 15.0f);
        this.reassessWeaponGoal();
    }

    public float getPickRadius() {
        return 0.3f;
    }

    public boolean isBaby() {
        return true;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).withEyeHeight(this.getType().getDimensions().eyeHeight() * (this.isBaby() ? 0.534f : 1.0f));
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
        this.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
    }

    protected void doFreezeConversion() {
        this.convertTo((EntityType)ModRegistry.BABY_STRAY_ENTITY_TYPE.value(), ConversionParams.single((Mob)this, (boolean)true, (boolean)true), stray -> {
            stray.detectEquipmentUpdates();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                stray.setItemSlot(slot, ItemStack.EMPTY);
            }
            stray.populateDefaultEquipmentSlots(this.random, stray.level().getCurrentDifficultyAt(stray.blockPosition()));
            if (!this.isSilent()) {
                this.level().levelEvent(null, 1048, this.blockPosition(), 0);
            }
        });
    }

    public void aiStep() {
        super.aiStep();
        if (this.level() instanceof ServerLevel) {
            if (this.switchWeaponCooldown > 0) {
                --this.switchWeaponCooldown;
            }
            if (this.switchWeaponCooldown == 0) {
                if (this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) < 16.0) {
                    if (ToolTypeHelper.INSTANCE.isBow(this.getMainHandItem())) {
                        this.setHandItems(this.getOffhandItem(), this.getMainHandItem());
                        this.switchWeaponCooldown = 60;
                    }
                } else if ((this.getTarget() == null || this.distanceToSqr((Entity)this.getTarget()) > 36.0) && ToolTypeHelper.INSTANCE.isSword(this.getMainHandItem())) {
                    this.setHandItems(this.getOffhandItem(), this.getMainHandItem());
                    this.switchWeaponCooldown = 60;
                }
            }
        }
    }

    private void setHandItems(ItemStack mainHand, ItemStack offHand) {
        this.setItemInHand(InteractionHand.MAIN_HAND, mainHand);
        this.setItemInHand(InteractionHand.OFF_HAND, offHand);
    }

    public void reassessWeaponGoal() {
        if (this.level() instanceof ServerLevel) {
            this.goalSelector.removeGoal((Goal)this.meleeGoal);
            this.goalSelector.removeGoal((Goal)this.bowGoal);
            if (this.getMainHandItem().getItem() instanceof BowItem) {
                int attackInterval = this.getHardAttackInterval();
                if (this.level().getDifficulty() != Difficulty.HARD) {
                    attackInterval = this.getAttackInterval();
                }
                this.bowGoal.setMinAttackInterval(attackInterval);
                this.goalSelector.addGoal(4, (Goal)this.bowGoal);
            } else {
                this.goalSelector.addGoal(4, (Goal)this.meleeGoal);
            }
        }
    }

    protected int getHardAttackInterval() {
        return super.getHardAttackInterval() - 10;
    }

    protected int getAttackInterval() {
        return super.getAttackInterval() - 10;
    }
}

