/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.world.entity.monster;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;

public interface SkullCarryingMob {
    default public boolean renderCarryingSkull() {
        return !this.getSkullItem().isEmpty();
    }

    public ItemStack getSkullItem();

    default public boolean isOnlyCarryingSkull(LivingEntity entity, InteractionHand hand) {
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        return this.isSkullItem(entity.getItemInHand(hand)) && entity.getItemInHand(otherHand).isEmpty();
    }

    default public boolean isSkullItem(ItemStack itemStack) {
        Item item;
        if (!itemStack.isEmpty() && (item = itemStack.getItem()) instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            return item2.getBlock() instanceof AbstractSkullBlock;
        }
        return false;
    }

    public boolean isDancing();
}

