/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles;

import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.client.RepaintableBlockModel;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.DataCollector;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpoles.blocks.PoleBlock;
import com.endertech.minecraft.mods.adpoles.client.HolderRenderer;
import com.endertech.minecraft.mods.adpoles.data.ModBlockTags;
import com.endertech.minecraft.mods.adpoles.data.ModItemTags;
import com.endertech.minecraft.mods.adpoles.data.ModLootTables;
import com.endertech.minecraft.mods.adpoles.data.ModRecipes;
import com.endertech.minecraft.mods.adpoles.data.MovableApexes;
import com.endertech.minecraft.mods.adpoles.data.Pole;
import com.endertech.minecraft.mods.adpoles.entities.Holder;
import com.endertech.minecraft.mods.adpoles.init.Blocks;
import com.endertech.minecraft.mods.adpoles.init.Entities;
import com.endertech.minecraft.mods.adpoles.init.Items;
import com.endertech.minecraft.mods.adpoles.init.Tiles;
import com.endertech.minecraft.mods.adpoles.network.HolderMsg;
import com.endertech.minecraft.mods.adpoles.network.JumpMsg;
import com.endertech.minecraft.mods.adpoles.network.PoleGrabMsg;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@Mod(value="adpoles")
public class AdPoles
extends AbstractForgeMod {
    public static final String ID = "adpoles";
    private static AdPoles instance;
    public final Blocks blocks;
    public final Items items;
    public final Entities entities;
    public final Tiles tiles;

    public static AdPoles getInstance() {
        return instance;
    }

    public AdPoles(IEventBus modEventBus, ModContainer modContainer) {
        super(modEventBus, modContainer);
        instance = this;
        this.blocks = new Blocks(this);
        this.items = new Items(this);
        this.entities = new Entities(this);
        this.tiles = new Tiles(this);
        this.registerCommonConfig();
        this.registerClientConfig();
    }

    public String getId() {
        return ID;
    }

    public void gatherData(DataCollector collector) {
        collector.addBlockAndItemTags(ModBlockTags::new, ModItemTags::new).addRecipes(ModRecipes::new).addLootTables(ModLootTables::new);
    }

    public void clientInit() {
        this.setRenderLayer((Block)this.blocks.glass_pole.get(), ChunkSectionLayer.TRANSLUCENT);
        this.setRenderLayer((Block)this.blocks.iron_pole.get(), ChunkSectionLayer.CUTOUT_MIPPED);
        this.setRenderLayer((Block)this.blocks.redstone_pole.get(), ChunkSectionLayer.CUTOUT_MIPPED);
        this.setRenderLayer((Block)this.blocks.wooden_pole.get(), ChunkSectionLayer.CUTOUT_MIPPED);
    }

    public void clientBuildCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            this.items.streamAll().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }

    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        this.blocks.streamAll().filter(PoleBlock.class::isInstance).flatMap(block -> block.getStateDefinition().getPossibleStates().stream()).forEach(state -> registry.replaceModelOf(state, RepaintableBlockModel::new));
    }

    public void clientRegisterRenderers() {
        this.registerEntityRender((EntityType)this.entities.holder.get(), HolderRenderer::new);
    }

    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        PoleBlock.movableApexes = new MovableApexes(value.builder, "List of blocks that can be moved along with the top of the pole", new String[]{"#minecraft:banners", "#c:chests", "hopper:*", "torch:*", "soul_torch:*", "redstone_torch:*", "campfire:*", "soul_campfire:*"});
        PoleBlock.quickExtension = value.comment("Allows to quickly extend a pole by right-clicking it with a pole item").define("quickExtension", true);
        PoleBlock.maxPolesAtOnce = value.comment("Number of poles that can be placed(when holding pole items in both hands) / broken(when crouching) at once").defineInRange("maxPolesAtOnce", 8, IntBounds.between((Integer)1, (Integer)128));
        value.shared("Painting");
        value.push("SlidingMechanics");
        for (Pole.OptionalBlocks optionalBlocks : Pole.OptionalBlocks.values()) {
            String path = String.join((CharSequence)"", UnitId.splitRegName((String)optionalBlocks.name().toLowerCase(Locale.ROOT), (boolean)true, (boolean)false));
            optionalBlocks.enabled = value.comment("Enables/disables sliding mechanics for this type of blocks").define(path, true);
        }
        value.pop();
        value.push("SpeedLimits");
        for (Enum enum_ : Pole.Materials.values()) {
            String poleType = CommonString.capitalizeFirstChar((String)enum_.getName()) + "Poles";
            value.push(poleType);
            ((Pole.Materials)enum_).defineAcceleration(value);
            ((Pole.Materials)enum_).defineSpeedLimits(value);
            value.pop();
        }
        value.pop();
    }

    public void clientConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        Holder.switchToThirdPersonView = value.comment("Enables automatic switching to a third-person view while holding the pole").define("switchToThirdPersonView", true);
        Holder.basicSlidingControl = value.comment("Switches between one key 'moveForward' and two keys 'moveForward/moveBackward' controls").define("basicSlidingControl", false);
    }

    public void configUpdated(ModConfig config) {
        if (config.getType() == ModConfig.Type.COMMON) {
            PoleBlock.movableApexes.loadData();
        }
    }

    public void tagsUpdated() {
        PoleBlock.movableApexes.loadData();
    }

    public void registerNetMessages(Consumer<Supplier<ForgeNetMsg<?>>> consumer) {
        consumer.accept(HolderMsg::new);
        consumer.accept(PoleGrabMsg::new);
        consumer.accept(JumpMsg::new);
    }
}

