/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.blocks;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.tiles.RepaintableBlockTile;
import com.endertech.minecraft.mods.adpoles.AdPoles;
import com.endertech.minecraft.mods.adpoles.data.ModItemTags;
import com.endertech.minecraft.mods.adpoles.data.MovableApexes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ModConfigSpec;

public class PoleBlock
extends ForgeBlock
implements IPole,
ITiledBlock<Tile> {
    public static MovableApexes movableApexes;
    public static ModConfigSpec.ConfigValue<Boolean> quickExtension;
    public static ModConfigSpec.ConfigValue<Integer> maxPolesAtOnce;
    public static final VoxelShape SHAPE;

    public PoleBlock(Properties<?> props) {
        super(null, props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape shape(float width) {
        double radius = width / 2.0f;
        return Block.box((double)(8.0 - radius), (double)0.0, (double)(8.0 - radius), (double)(8.0 + radius), (double)16.0, (double)(8.0 + radius));
    }

    public Tile createTile(BlockPos pos, BlockState state) {
        return new Tile(pos, state);
    }

    public Class<Tile> getTileClass() {
        return Tile.class;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)false);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        return IWaterLoggable.updateFluidPostPlacement((LevelReader)level, (ScheduledTickAccess)tickAccess, (BlockPos)pos, (BlockState)state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return IWaterLoggable.getStateForPlacement((BlockPlaceContext)context, (BlockState)this.defaultBlockState());
    }

    public static Vect3d getCenterWithY(BlockPos pos, double y) {
        return Vect3d.from((double)((double)pos.getX() + 0.5), (double)y, (double)((double)pos.getZ() + 0.5));
    }

    public boolean isApex(BlockState state) {
        return movableApexes.contains(state);
    }

    public boolean isPole(BlockState state) {
        return state.getBlock() instanceof IPole;
    }

    public Direction getSlideDirection(LevelReader level, BlockPos pos, BlockState state) {
        return Direction.DOWN;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.canStayAt(level, pos);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)quickExtension.get()).booleanValue() && stack.is(ModItemTags.POLES)) {
            int quantity = player.getOffhandItem().getItem() == player.getMainHandItem().getItem() ? (Integer)maxPolesAtOnce.get() : 1;
            return this.buildBy(player, level, pos, hand, hit, quantity);
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int quantity = player.isCrouching() ? (Integer)maxPolesAtOnce.get() : 1;
            this.breakBy(player, server, pos, quantity);
        }
        return false;
    }

    static {
        SHAPE = Shapes.box((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)1.0, (double)0.6);
    }

    public static class Tile
    extends RepaintableBlockTile {
        public Tile(BlockPos pos, BlockState state) {
            super((BlockEntityType)AdPoles.getInstance().tiles.pole.get(), pos, state);
        }
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeBlock.Properties<T> {
        protected Properties(Class<T> selfClass, ResourceKey<Block> blockId) {
            super(selfClass, blockId);
        }

        public static Properties<?> of(ResourceKey<Block> blockId) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, blockId);
            props.noOcclusion();
            return props;
        }

        public static Properties<?> ofWood(ResourceKey<Block> blockId) {
            Properties<?> props = Properties.of(blockId);
            props.vanillaProps.strength(2.0f).ignitedByLava().requiresCorrectToolForDrops().sound(SoundType.METAL);
            return props;
        }

        public static Properties<?> ofMetal(ResourceKey<Block> blockId) {
            Properties<?> props = Properties.of(blockId);
            props.vanillaProps.strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL);
            return props;
        }

        public static Properties<?> ofGlass(ResourceKey<Block> blockId) {
            Properties<?> props = Properties.of(blockId);
            props.vanillaProps.strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn((s, w, p, a) -> false).isRedstoneConductor((s, w, p) -> false).isSuffocating((s, w, p) -> false).isViewBlocking((s, w, p) -> false);
            return props;
        }
    }
}

