/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.blocks;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpoles.blocks.PoleBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;

public class PoweredPoleBlock
extends PoleBlock {
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");

    public PoweredPoleBlock(PoleBlock.Properties<?> props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    @Override
    public Direction getSlideDirection(LevelReader level, BlockPos pos, BlockState state) {
        if (this.isPoweredPole((BlockGetter)level, pos, state)) {
            return Direction.UP;
        }
        return super.getSlideDirection(level, pos, state);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        if (side != null) {
            switch (side) {
                case UP: 
                case DOWN: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPoweredPole(BlockGetter level, BlockPos pos, BlockState state) {
        return state.is((Block)this) && (Boolean)state.getValue((Property)POWERED) != false;
    }

    public void updatePoweredState(Level level, BlockPos pos, BlockState state) {
        boolean powered;
        BlockState newstate;
        if (GameWorld.isServerSide((LevelReader)level) && state != (newstate = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered = this.findPowerSource((LevelReader)level, pos))))) {
            level.setBlockAndUpdate(pos, newstate);
        }
    }

    protected boolean findPowerSource(LevelReader level, BlockPos startPos) {
        for (Direction facing : new Direction[]{Direction.DOWN, Direction.UP}) {
            BlockPos pos = startPos;
            while (level.getBlockState(pos).is((Block)this)) {
                boolean found = level.hasSignal(pos.relative(facing), facing.getOpposite());
                if (found) {
                    return true;
                }
                pos = pos.relative(facing);
            }
        }
        return false;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation orientation, boolean isMoving) {
        this.updatePoweredState(level, pos, state);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updatePoweredState(world, pos, state);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.isPoweredPole(world, pos, state) ? 1 : super.getLightEmission(state, world, pos);
    }
}

