/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.data;

import com.endertech.minecraft.mods.adpoles.AdPoles;
import com.endertech.minecraft.mods.adpoles.blocks.PoleBlock;
import com.endertech.minecraft.mods.adpoles.init.Blocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class ModRecipes
extends RecipeProvider {
    public ModRecipes(HolderLookup.Provider lookupProvider, RecipeOutput recipeOutput) {
        super(lookupProvider, recipeOutput);
    }

    protected void buildPole(PoleBlock pole, TagKey<Item> material, int count, RecipeOutput output) {
        this.shaped(RecipeCategory.TRANSPORTATION, (ItemLike)pole, count).pattern(" I ").pattern(" I ").pattern(" I ").define(Character.valueOf('I'), material).unlockedBy("has_item", this.has(material)).save(output);
    }

    protected void buildRecipes() {
        Blocks blocks = AdPoles.getInstance().blocks;
        this.buildPole((PoleBlock)((Object)blocks.iron_pole.get()), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON, 32, this.output);
        this.buildPole((PoleBlock)((Object)blocks.redstone_pole.get()), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, 48, this.output);
        this.buildPole((PoleBlock)((Object)blocks.glass_pole.get()), (TagKey<Item>)Tags.Items.GLASS_BLOCKS, 24, this.output);
        this.buildPole((PoleBlock)((Object)blocks.wooden_pole.get()), (TagKey<Item>)ItemTags.LOGS, 16, this.output);
    }
}

