/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.data;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpoles.blocks.PoleBlock;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ModConfigSpec;

public record Pole(Materials material, LevelReader level, BlockPos pos, BlockState state) {
    public static Optional<Pole> get(LevelReader level, BlockPos pos) {
        if (GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos)) {
            BlockState state = level.getBlockState(pos);
            return Pole.getMaterial(level, pos, state).map(mat -> new Pole((Materials)((Object)mat), level, pos, state));
        }
        return Optional.empty();
    }

    public static Optional<Materials> getMaterial(LevelReader level, BlockPos pos, BlockState state) {
        VoxelShape shape;
        if (state.isAir()) {
            return Optional.empty();
        }
        Block block = state.getBlock();
        Materials material = Materials.bySound(state.getSoundType());
        if (block instanceof IPole) {
            return Optional.of(material);
        }
        if (!(!(block instanceof FenceBlock) || ((Boolean)state.getValue((Property)FenceBlock.NORTH)).booleanValue() || ((Boolean)state.getValue((Property)FenceBlock.EAST)).booleanValue() || ((Boolean)state.getValue((Property)FenceBlock.SOUTH)).booleanValue() || ((Boolean)state.getValue((Property)FenceBlock.WEST)).booleanValue())) {
            return material.getIf(OptionalBlocks.WOODEN_FENCES.enabled);
        }
        if (block instanceof BambooStalkBlock) {
            return material.getIf(OptionalBlocks.BAMBOO_PLANTS.enabled);
        }
        if (block instanceof ChainBlock && ((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)).isVertical()) {
            return material.getIf(OptionalBlocks.CHAINS.enabled);
        }
        if (!(!(block instanceof IronBarsBlock) || ((Boolean)state.getValue((Property)IronBarsBlock.NORTH)).booleanValue() || ((Boolean)state.getValue((Property)IronBarsBlock.EAST)).booleanValue() || ((Boolean)state.getValue((Property)IronBarsBlock.SOUTH)).booleanValue() || ((Boolean)state.getValue((Property)IronBarsBlock.WEST)).booleanValue())) {
            if (state.getSoundType() == SoundType.METAL) {
                return material.getIf(OptionalBlocks.IRON_BARS.enabled);
            }
            if (state.getSoundType() == SoundType.GLASS) {
                return material.getIf(OptionalBlocks.GLASS_PANES.enabled);
            }
        }
        if (state.isFaceSturdy((BlockGetter)level, pos, Direction.DOWN, SupportType.CENTER) && !state.isFaceSturdy((BlockGetter)level, pos, Direction.DOWN) && !state.isFaceSturdy((BlockGetter)level, pos, Direction.UP) && Shapes.joinUnoptimized((VoxelShape)(shape = state.getShape((BlockGetter)level, pos)), (VoxelShape)PoleBlock.shape(2.0f), (BooleanOp)BooleanOp.ONLY_SECOND).isEmpty() && Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)PoleBlock.shape(4.0f), (BooleanOp)BooleanOp.ONLY_FIRST).isEmpty()) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
            if (name.contains("post")) {
                return material.getIf(OptionalBlocks.POSTS.enabled);
            }
            if (name.contains("fence")) {
                return material.getIf(OptionalBlocks.MODDED_FENCES.enabled);
            }
        }
        return Optional.empty();
    }

    public boolean isRidableFor(Entity entity) {
        boolean maxObstacles = true;
        int count = 0;
        for (BlockPos check : GameWorld.Positions.getAroundHoriz((BlockPos)this.pos, (boolean)false, (BlockPos[])new BlockPos[0])) {
            if (Pole.isObstacleFor(entity, check)) {
                ++count;
            }
            if (count <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isRidableBelowFor(Entity entity) {
        return Pole.get(this.level, this.pos().below()).map(p -> p.isRidableFor(entity)).orElse(false);
    }

    public boolean isObstacleAbove(Entity entity) {
        double margin = 0.4f;
        double y = entity.getY() + (double)entity.getBbHeight() + margin;
        BlockPos top = BlockPos.containing((double)this.pos.getX(), (double)y, (double)this.pos.getZ());
        return Pole.isObstacleFor(entity, top);
    }

    public boolean isLongEnoughFor(Entity entity) {
        int length = Mth.ceil((float)entity.getBbHeight());
        return this.hasLengthIn(Direction.UP, length);
    }

    public boolean hasLengthIn(Direction direction, int length) {
        int count;
        for (count = 0; count < length && Pole.get(this.level, this.pos.relative(direction, count)).isPresent(); ++count) {
        }
        return count >= length;
    }

    public static boolean isObstacleFor(Entity entity, BlockPos pos) {
        Level level = entity.level();
        if (!GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos)) {
            return true;
        }
        BlockState state = level.getBlockState(pos);
        if (state.isAir()) {
            return false;
        }
        if (state.isPathfindable(PathComputationType.LAND)) {
            return false;
        }
        if (state.isSolidRender()) {
            return true;
        }
        if (state.isFaceSturdy((BlockGetter)level, pos, Direction.DOWN)) {
            return true;
        }
        VoxelShape shape = state.getCollisionShape((BlockGetter)level, pos, CollisionContext.of((Entity)entity));
        if (shape.isEmpty()) {
            return false;
        }
        AABB aabb = shape.bounds();
        if (aabb == null) {
            return false;
        }
        double length = 0.5;
        return !(aabb.maxX - aabb.minX < 0.5) || !(aabb.maxZ - aabb.minZ < 0.5);
    }

    public static Optional<Pole> findReachableFor(Entity entity) {
        Level level = entity.level();
        Vec3 look = entity.getLookAngle();
        look = new Vec3(look.x, 0.0, look.z);
        AABB bb = entity.getBoundingBox();
        bb = bb.move(look);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int y = Mth.floor((double)bb.minY);
        while ((double)y <= bb.maxY) {
            int x = Mth.floor((double)bb.minX);
            while ((double)x <= bb.maxX) {
                int z = Mth.floor((double)bb.minZ);
                while ((double)z <= bb.maxZ) {
                    pos.set(x, y, z);
                    Optional<Pole> pole = Pole.get((LevelReader)level, (BlockPos)pos);
                    if (pole.isPresent()) {
                        return pole;
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        return Optional.empty();
    }

    public boolean canBeHeldBy(Entity entity) {
        if (!entity.isAlive()) {
            return false;
        }
        if (entity.isPassenger()) {
            return false;
        }
        if (entity.isCrouching()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isSpectator()) {
                return false;
            }
            if (player.isCreative() && player.getAbilities().flying) {
                return false;
            }
        }
        return true;
    }

    public float getMaxVelocity(SpeedLimits limits) {
        return this.material.getMaxVelocity(this.level, this.pos, this.state, limits);
    }

    public Direction getSlideDirection() {
        return this.material.getSlideDirection(this.level, this.pos, this.state);
    }

    public float getAcceleration() {
        return this.material.getAcceleration(this.level, this.pos, this.state);
    }

    public static enum Materials implements IForgeEnum
    {
        METAL(0.5f),
        GLASS(0.8f),
        WOODEN(0.2f);

        private final float speedFactor;
        private ModConfigSpec.ConfigValue<Double> acceleration;
        private final EnumMap<SpeedLimits, ModConfigSpec.ConfigValue<Double>> maxVelocityMap = new EnumMap(SpeedLimits.class);

        private Materials(float speedFactor) {
            this.speedFactor = speedFactor;
        }

        public Optional<Materials> getIf(ModConfigSpec.ConfigValue<Boolean> enabled) {
            return enabled != null && (Boolean)enabled.get() != false ? Optional.of(this) : Optional.empty();
        }

        public static Materials bySound(SoundType sound) {
            if (sound == SoundType.GLASS) {
                return GLASS;
            }
            if (sound == SoundType.METAL || sound == SoundType.COPPER || sound == SoundType.CHAIN) {
                return METAL;
            }
            return WOODEN;
        }

        public void defineSpeedLimits(AbstractForgeMod.ConfigValueBuilder builder) {
            for (SpeedLimits limits : SpeedLimits.values()) {
                float defaultValue = (limits == SpeedLimits.CLIMBING ? limits.bounds.interpolateDown(this.speedFactor) : limits.bounds.interpolateUp(this.speedFactor)).floatValue();
                defaultValue = GameMath.roundTo((float)defaultValue, (int)-2);
                String comment = "Maximum " + limits.getName() + " speed " + limits.direction + " the pole";
                ModConfigSpec.ConfigValue value = builder.comment(comment).defineInRange(limits.getName(), defaultValue, limits.bounds);
                this.maxVelocityMap.put(limits, (ModConfigSpec.ConfigValue<Double>)value);
            }
        }

        public void defineAcceleration(AbstractForgeMod.ConfigValueBuilder builder) {
            this.acceleration = builder.comment("Defines how fast sliding velocity changes").defineInRange("acceleration", 0.04f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.1f)));
        }

        public float getMaxVelocity(LevelReader level, BlockPos pos, BlockState state, SpeedLimits limits) {
            float waterReduction = IWaterLoggable.isWaterlogged((BlockState)state) ? 4.0f : 1.0f;
            return ((Double)this.maxVelocityMap.get((Object)limits).get()).floatValue() / waterReduction;
        }

        public Direction getSlideDirection(LevelReader level, BlockPos pos, BlockState state) {
            Direction direction;
            Block block = state.getBlock();
            if (block instanceof PoleBlock) {
                PoleBlock pole = (PoleBlock)block;
                direction = pole.getSlideDirection(level, pos, state);
            } else {
                direction = Direction.DOWN;
            }
            return direction;
        }

        public float getAcceleration(LevelReader level, BlockPos pos, BlockState state) {
            float waterReduction = IWaterLoggable.isWaterlogged((BlockState)state) ? 2.0f : 1.0f;
            return ((Double)this.acceleration.get()).floatValue() / waterReduction;
        }
    }

    public static enum OptionalBlocks {
        GLASS_PANES,
        WOODEN_FENCES,
        IRON_BARS,
        CHAINS,
        BAMBOO_PLANTS,
        MODDED_FENCES,
        POSTS;

        public ModConfigSpec.ConfigValue<Boolean> enabled;
    }

    public static enum SpeedLimits implements IForgeEnum
    {
        CLIMBING(0.0f, 0.4f, "up"),
        SLIDING(0.0f, 0.8f, "down"),
        SPINNING(0.0f, 0.2f, "around");

        public final FloatBounds bounds;
        public final String direction;

        private SpeedLimits(float min, float max, String direction) {
            this.bounds = FloatBounds.between((Float)Float.valueOf(min), (Float)Float.valueOf(max));
            this.direction = direction;
        }
    }
}

