/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.entities;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpoles.AdPoles;
import com.endertech.minecraft.mods.adpoles.blocks.PoleBlock;
import com.endertech.minecraft.mods.adpoles.data.Pole;
import com.endertech.minecraft.mods.adpoles.network.HolderMsg;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.fluids.FluidType;

public class Holder
extends ForgeEntity {
    private static final float MAX_DELTA_YAW = 105.0f;
    private static final Vect3d UP_UNIT_VECTOR = Vect3d.from((double)0.0, (double)1.0, (double)0.0);
    private static final EntityDataAccessor<Optional<BlockPos>> POLE_POS = SynchedEntityData.defineId(Holder.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Float> SPIN_RADIUS = SynchedEntityData.defineId(Holder.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SPIN_VELOCITY = SynchedEntityData.defineId(Holder.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ACCELERATION = SynchedEntityData.defineId(Holder.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Direction> SLIDE_DIRECTION = SynchedEntityData.defineId(Holder.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    public static ModConfigSpec.ConfigValue<Boolean> switchToThirdPersonView;
    public static ModConfigSpec.ConfigValue<Boolean> basicSlidingControl;
    private float deltaRotation;
    private CameraType savedPointOfView;

    public Holder(EntityType<?> type, Level world) {
        super(type, world);
    }

    public Holder(Level world, Player player, BlockPos polePos) {
        super((EntityType)AdPoles.getInstance().entities.holder.get(), world);
        this.copyPosition((Entity)player);
        this.setPolePos(polePos);
        this.setSpinRadius(player.getBbWidth() * 0.8f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(POLE_POS, Optional.empty());
        builder.define(ACCELERATION, (Object)Float.valueOf(0.0f));
        builder.define(SPIN_RADIUS, (Object)Float.valueOf(0.0f));
        builder.define(SPIN_VELOCITY, (Object)Float.valueOf(0.0f));
        builder.define(SLIDE_DIRECTION, (Object)Direction.DOWN);
    }

    public void updateSpinVelocity(float deltaYaw) {
        this.getPole().ifPresent(pole -> {
            float yawFactor = deltaYaw / 105.0f;
            float maxSpinVelocity = pole.getMaxVelocity(Pole.SpeedLimits.SPINNING);
            float spinVelocity = maxSpinVelocity * yawFactor;
            this.setSpinVelocity(spinVelocity);
        });
    }

    public void updateSlideAcceleration(PlayerAction action) {
        Pole pole = this.getPole().orElse(null);
        if (pole != null) {
            Direction direction = pole.getSlideDirection();
            float targetVelocity = pole.getMaxVelocity(Pole.SpeedLimits.SLIDING);
            if (direction == Direction.DOWN) {
                targetVelocity = -targetVelocity;
            }
            switch (action.ordinal()) {
                case 1: {
                    break;
                }
                case 2: {
                    targetVelocity = 0.0f;
                    break;
                }
                case 3: {
                    targetVelocity = pole.getMaxVelocity(Pole.SpeedLimits.CLIMBING);
                    if (direction != Direction.UP) break;
                    targetVelocity = -targetVelocity;
                    break;
                }
            }
            float acceleration = Mth.clamp((float)((float)((double)targetVelocity - this.getDeltaMovement().y)), (float)(-pole.getAcceleration()), (float)pole.getAcceleration());
            this.setSlideAcceleration(acceleration);
            this.setSlideDirection(direction);
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity pPassenger) {
        return new Vec3(this.getX(), this.getBoundingBox().maxY + 0.5, this.getZ());
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return Optional.ofNullable(this.getFirstPassenger()).filter(LivingEntity.class::isInstance).orElse(null);
    }

    public void tick() {
        BlockPos polePos;
        this.setOnGround(true);
        LivingEntity passenger = this.getControllingPassenger();
        Pole pole = this.getPole().orElse(null);
        if (!(passenger instanceof Player && pole != null && passenger.isAlive() && pole.isRidableFor((Entity)passenger) && pole.isRidableBelowFor((Entity)passenger))) {
            if (this.isServerSide()) {
                if (passenger != null) {
                    passenger.stopRiding();
                }
                this.discard();
            }
            return;
        }
        passenger.setOnGround(true);
        float slideAcceleration = this.getSlideAcceleration();
        this.addMotion(0.0, slideAcceleration, 0.0);
        if (this.getDeltaMovement().y > 0.0 && (!pole.isLongEnoughFor((Entity)passenger) || pole.isObstacleAbove((Entity)passenger))) {
            this.setDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
        }
        if (this.level().isClientSide() && passenger instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)passenger;
            PlayerAction action = PlayerAction.NONE;
            Options gs = GameKeys.getGameSettings();
            boolean isSprinting = gs.keySprint.isDown();
            if (gs.keyShift.isDown()) {
                action = PlayerAction.DISMOUNT;
            } else if (gs.keyJump.isDown()) {
                action = PlayerAction.JUMP;
            } else if (((Boolean)basicSlidingControl.get()).booleanValue()) {
                if (gs.keyUp.isDown()) {
                    action = isSprinting ? PlayerAction.CLIMB : PlayerAction.STOP;
                }
            } else {
                boolean lookingForward;
                Vec3 lookVec = player.getLookAngle();
                Direction direction = this.getSlideDirection();
                boolean bl = lookingForward = direction == Direction.DOWN && lookVec.y < 0.0 || direction == Direction.UP && lookVec.y > 0.0;
                if (gs.keyUp.isDown() && !lookingForward) {
                    PlayerAction playerAction = action = isSprinting ? PlayerAction.CLIMB : PlayerAction.STOP;
                }
                if (gs.keyDown.isDown() && lookingForward) {
                    action = isSprinting ? PlayerAction.CLIMB : PlayerAction.STOP;
                }
            }
            float headYaw = passenger.getYHeadRot();
            float holderYaw = this.getYRot();
            float deltaYaw = Mth.wrapDegrees((float)(headYaw - holderYaw));
            new HolderMsg(this, action, deltaYaw).sendToServer();
        }
        if ((polePos = pole.pos()).getY() != this.blockPosition().getY()) {
            polePos = BlockPos.containing((double)polePos.getX(), (double)this.position().y(), (double)polePos.getZ());
            this.setPolePos(polePos);
        }
        Vect3d poleCenter = PoleBlock.getCenterWithY(polePos, this.getY());
        Vect3d radiusVec = this.getCorrectedRadiusVector(polePos);
        float spinVelocity = this.getSpinVelocity();
        float yaw = 180.0f - radiusVec.yaw();
        this.deltaRotation = Mth.wrapDegrees((float)(yaw - this.getYRot()));
        Vect3d spinVec = radiusVec.mult(UP_UNIT_VECTOR).scale((double)spinVelocity);
        Vect3d destPos = poleCenter.add(radiusVec.scale((double)this.getSpinRadius())).add(spinVec).move(0.0, this.getDeltaMovement().y, 0.0);
        this.absSnapTo(destPos.x, destPos.y, destPos.z, yaw, this.getXRot());
    }

    protected Optional<Direction> getNearbyWallDirection() {
        Pole pole = this.getPole().orElse(null);
        LivingEntity passenger = this.getControllingPassenger();
        if (pole != null && passenger != null) {
            for (Direction dir : GameWorld.Directions.of().horizontals().toArray()) {
                BlockPos pos = pole.pos().relative(dir);
                if (!Pole.isObstacleFor((Entity)passenger, pos) && !Pole.isObstacleFor((Entity)passenger, pos.above())) continue;
                return Optional.of(dir);
            }
        }
        return Optional.empty();
    }

    protected Vect3d getCorrectedRadiusVector(BlockPos polePos) {
        Vect3d poleCenter = PoleBlock.getCenterWithY(polePos, this.getY());
        Vect3d radiusVec = this.getCurPosition().subtract(poleCenter).normalize();
        Direction wallDirection = this.getNearbyWallDirection().orElse(null);
        if (wallDirection == null) {
            return radiusVec;
        }
        Vect3d wallCenter = PoleBlock.getCenterWithY(polePos.relative(wallDirection), this.getY());
        float wallYaw = wallCenter.subtract(poleCenter).yaw();
        float amplitude = 80.0f;
        float minYaw = wallYaw - amplitude;
        float maxYaw = wallYaw + amplitude;
        if (maxYaw >= 360.0f) {
            minYaw -= 360.0f;
            maxYaw -= 360.0f;
        }
        FloatBounds bounds = FloatBounds.between((Float)Float.valueOf(minYaw), (Float)Float.valueOf(maxYaw));
        float curYaw = radiusVec.yaw();
        if (curYaw < 0.0f && bounds.getMin().floatValue() >= 0.0f) {
            curYaw = 360.0f + curYaw;
        }
        if (bounds.encloses(Float.valueOf(curYaw))) {
            float deltaYaw = 0.0f;
            deltaYaw = curYaw - bounds.getMin().floatValue() < bounds.getMax().floatValue() - curYaw ? curYaw - bounds.getMin().floatValue() : curYaw - bounds.getMax().floatValue();
            radiusVec = radiusVec.rotateYaw(deltaYaw);
        }
        return radiusVec;
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        passenger.setYRot(passenger.getYRot() + this.deltaRotation);
        passenger.setYHeadRot(passenger.getYHeadRot() + this.deltaRotation);
        this.onPassengerTurned(passenger);
    }

    public void onPassengerTurned(Entity entity) {
        entity.setYBodyRot(this.getYRot());
        float delta = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float clamped = Mth.clamp((float)delta, (float)-105.0f, (float)105.0f);
        entity.setYRot(entity.getYRot() + clamped - delta);
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public float getSpinRadius() {
        return ((Float)this.entityData.get(SPIN_RADIUS)).floatValue();
    }

    public void setSpinRadius(float spinRadius) {
        this.entityData.set(SPIN_RADIUS, (Object)Float.valueOf(spinRadius));
    }

    public float getSpinVelocity() {
        return ((Float)this.entityData.get(SPIN_VELOCITY)).floatValue();
    }

    public void setSpinVelocity(float spinVelocity) {
        this.entityData.set(SPIN_VELOCITY, (Object)Float.valueOf(spinVelocity));
    }

    public float getSlideAcceleration() {
        return ((Float)this.entityData.get(ACCELERATION)).floatValue();
    }

    public Direction getSlideDirection() {
        return (Direction)this.entityData.get(SLIDE_DIRECTION);
    }

    public void setSlideAcceleration(float slideAcceleration) {
        this.entityData.set(ACCELERATION, (Object)Float.valueOf(slideAcceleration));
    }

    public void setSlideDirection(Direction direction) {
        this.entityData.set(SLIDE_DIRECTION, (Object)direction);
    }

    public Optional<Pole> getPole() {
        return ((Optional)this.getEntityData().get(POLE_POS)).flatMap(pos -> Pole.get((LevelReader)this.level(), pos));
    }

    public void setPolePos(@Nullable BlockPos pos) {
        this.entityData.set(POLE_POS, Optional.ofNullable(pos));
    }

    protected void addPassenger(Entity passenger) {
        if (this.isClientSide() && ((Boolean)switchToThirdPersonView.get()).booleanValue() && passenger instanceof LocalPlayer) {
            Options settings = Minecraft.getInstance().options;
            this.savedPointOfView = settings.getCameraType();
            if (settings.getCameraType() == CameraType.FIRST_PERSON) {
                settings.setCameraType(CameraType.THIRD_PERSON_BACK);
            }
        }
        super.addPassenger(passenger);
    }

    protected void removePassenger(Entity passenger) {
        if (this.isClientSide() && ((Boolean)switchToThirdPersonView.get()).booleanValue() && passenger instanceof LocalPlayer) {
            Minecraft.getInstance().options.setCameraType(this.savedPointOfView);
        }
        this.getPole().ifPresent(pole -> {
            float dist = passenger.getBbWidth();
            Vect3d poleCenter = PoleBlock.getCenterWithY(pole.pos(), this.getY());
            Vect3d radiusVec = this.getCorrectedRadiusVector(pole.pos());
            this.snapTo(poleCenter.add(radiusVec.scale((double)dist)).move(0.0, -0.5, 0.0).toVector3d());
        });
        super.removePassenger(passenger);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
    }

    public static enum PlayerAction {
        NONE,
        ACCELERATE,
        STOP,
        CLIMB,
        JUMP,
        DISMOUNT;

    }
}

