/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.events;

import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpoles.data.Pole;
import com.endertech.minecraft.mods.adpoles.network.PoleGrabMsg;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class Player {
    static final GameTime UPDATE_INTERVAL = GameTime.quaterSecond();

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        net.minecraft.world.entity.player.Player player;
        if (event.getEntity().level().isClientSide() && (player = event.getEntity()) instanceof LocalPlayer) {
            Pole pole;
            LocalPlayer player2 = (LocalPlayer)player;
            if (player2.onGround() || player2.input.keyPresses.jump()) {
                return;
            }
            if (!player2.isPassenger() && UPDATE_INTERVAL.pastIn(player2.level()) && (pole = (Pole)Pole.findReachableFor((Entity)player2).orElse(null)) != null && pole.canBeHeldBy((Entity)player2) && pole.isRidableFor((Entity)player2) && pole.isLongEnoughFor((Entity)player2) && pole.isRidableBelowFor((Entity)player2)) {
                new PoleGrabMsg((net.minecraft.world.entity.player.Player)player2, pole.pos()).sendToServer();
            }
        }
    }
}

