/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpoles.network;

import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adpoles.entities.Holder;
import com.endertech.minecraft.mods.adpoles.network.JumpMsg;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HolderMsg
extends ForgeNetMsg<HolderMsg> {
    public int holderId;
    public Holder.PlayerAction playerAction;
    public float deltaYaw;

    public HolderMsg() {
    }

    public HolderMsg(Holder holder, Holder.PlayerAction playerAction, float deltaYaw) {
        this.holderId = holder.getId();
        this.playerAction = playerAction;
        this.deltaYaw = deltaYaw;
    }

    public HolderMsg create() {
        return new HolderMsg();
    }

    public void handle(Level level, Player player) {
        Entity entity = level.getEntity(this.holderId);
        if (entity instanceof Holder) {
            Holder holder = (Holder)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                switch (this.playerAction) {
                    case DISMOUNT: {
                        holder.ejectPassengers();
                        break;
                    }
                    case JUMP: {
                        holder.ejectPassengers();
                        new JumpMsg().sendToPlayer(serverPlayer);
                        break;
                    }
                    default: {
                        holder.updateSlideAcceleration(this.playerAction);
                        holder.updateSpinVelocity(this.deltaYaw);
                    }
                }
            }
        }
    }
}

