/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.CreeperMinionEggModel;
import fuzs.mutantmonsters.client.model.CreeperMinionModel;
import fuzs.mutantmonsters.client.model.EndersoulFragmentModel;
import fuzs.mutantmonsters.client.model.EndersoulHandModel;
import fuzs.mutantmonsters.client.model.MutantArrowModel;
import fuzs.mutantmonsters.client.model.MutantCreeperModel;
import fuzs.mutantmonsters.client.model.MutantCrossbowModel;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.model.MutantSkeletonModel;
import fuzs.mutantmonsters.client.model.MutantSkeletonPartModel;
import fuzs.mutantmonsters.client.model.MutantSnowGolemModel;
import fuzs.mutantmonsters.client.model.MutantZombieModel;
import fuzs.mutantmonsters.client.model.SpiderPigModel;
import fuzs.mutantmonsters.client.particle.EndersoulParticle;
import fuzs.mutantmonsters.client.particle.SkullSpiritParticle;
import fuzs.mutantmonsters.client.renderer.ModRenderType;
import fuzs.mutantmonsters.client.renderer.entity.BodyPartRenderer;
import fuzs.mutantmonsters.client.renderer.entity.CreeperMinionEggRenderer;
import fuzs.mutantmonsters.client.renderer.entity.CreeperMinionRenderer;
import fuzs.mutantmonsters.client.renderer.entity.EndersoulCloneRenderer;
import fuzs.mutantmonsters.client.renderer.entity.EndersoulFragmentRenderer;
import fuzs.mutantmonsters.client.renderer.entity.MutantArrowRenderer;
import fuzs.mutantmonsters.client.renderer.entity.MutantCreeperRenderer;
import fuzs.mutantmonsters.client.renderer.entity.MutantEndermanRenderer;
import fuzs.mutantmonsters.client.renderer.entity.MutantSkeletonRenderer;
import fuzs.mutantmonsters.client.renderer.entity.MutantSnowGolemRenderer;
import fuzs.mutantmonsters.client.renderer.entity.MutantZombieRenderer;
import fuzs.mutantmonsters.client.renderer.entity.SkullSpiritRenderer;
import fuzs.mutantmonsters.client.renderer.entity.SpiderPigRenderer;
import fuzs.mutantmonsters.client.renderer.entity.ThrowableBlockRenderer;
import fuzs.mutantmonsters.client.renderer.entity.layers.CreeperMinionOnShoulderLayer;
import fuzs.mutantmonsters.client.renderer.special.EndersoulHandSpecialRenderer;
import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.world.item.ArmorBlockItem;
import fuzs.mutantmonsters.world.item.SkeletonArmorItem;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntitySpectatorShadersContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.ParticleProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderPipelinesContext;
import fuzs.puzzleslib.api.client.core.v1.context.SkullRenderersContext;
import fuzs.puzzleslib.api.client.event.v1.renderer.AddLivingEntityRenderLayersCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ExtractRenderStateCallback;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ItemTooltipRegistry;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class MutantMonstersClient
implements ClientModConstructor {
    public void onConstructMod() {
        MutantMonstersClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        AddLivingEntityRenderLayersCallback.EVENT.register(CreeperMinionOnShoulderLayer::addLivingEntityRenderLayers);
        ExtractRenderStateCallback.EVENT.register(CreeperMinionOnShoulderLayer::onExtractRenderState);
    }

    public void onClientSetup() {
        ItemTooltipRegistry.ITEM.registerItemTooltip(ArmorBlockItem.class, ArmorBlockItem::getDescriptionComponent);
        ItemTooltipRegistry.ITEM.registerItemTooltip(SkeletonArmorItem.class, SkeletonArmorItem::getDescriptionComponent);
    }

    public void onRegisterEntityRenderers(EntityRenderersContext context) {
        context.registerEntityRenderer((EntityType)ModEntityTypes.BODY_PART_ENTITY_TYPE.value(), BodyPartRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.value(), CreeperMinionRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.CREEPER_MINION_EGG_ENTITY_TYPE.value(), CreeperMinionEggRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.value(), EndersoulCloneRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.ENDERSOUL_FRAGMENT_ENTITY_TYPE.value(), EndersoulFragmentRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.MUTANT_ARROW_ENTITY_TYPE.value(), MutantArrowRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE.value(), MutantCreeperRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.MUTANT_ENDERMAN_ENTITY_TYPE.value(), MutantEndermanRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE.value(), MutantSkeletonRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.value(), MutantSnowGolemRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.MUTANT_ZOMBIE_ENTITY_TYPE.value(), MutantZombieRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.SKULL_SPIRIT_ENTITY_TYPE.value(), SkullSpiritRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.SPIDER_PIG_ENTITY_TYPE.value(), SpiderPigRenderer::new);
        context.registerEntityRenderer((EntityType)ModEntityTypes.THROWABLE_BLOCK_ENTITY_TYPE.value(), ThrowableBlockRenderer::new);
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((BlockEntityType)ModRegistry.SKULL_BLOCK_ENTITY_TYPE.value(), SkullBlockRenderer::new);
    }

    public void onRegisterItemModels(ItemModelsContext context) {
        context.registerSpecialModelRenderer(MutantMonsters.id("endersoul_hand"), EndersoulHandSpecialRenderer.Unbaked.MAP_CODEC);
    }

    public void onRegisterParticleProviders(ParticleProvidersContext context) {
        context.registerParticleProvider((ParticleType)ModRegistry.ENDERSOUL_PARTICLE_TYPE.value(), EndersoulParticle.Factory::new);
        context.registerParticleProvider((ParticleType)ModRegistry.SKULL_SPIRIT_PARTICLE_TYPE.value(), SkullSpiritParticle.Factory::new);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_SKELETON_SKULL, ModelLayerLocations::createSkullModelLayer);
        context.registerLayerDefinition(ModelLayerLocations.CREEPER_MINION_EGG, () -> CreeperMinionEggModel.createBodyLayer(new CubeDeformation(0.0f)));
        context.registerLayerDefinition(ModelLayerLocations.CREEPER_MINION_EGG_ARMOR, () -> CreeperMinionEggModel.createBodyLayer(new CubeDeformation(1.0f)));
        context.registerLayerDefinition(ModelLayerLocations.CREEPER_MINION, () -> CreeperModel.createBodyLayer((CubeDeformation)new CubeDeformation(0.0f)).apply(CreeperMinionModel.BABY_TRANSFORMER));
        context.registerLayerDefinition(ModelLayerLocations.CREEPER_MINION_ARMOR, () -> CreeperModel.createBodyLayer((CubeDeformation)new CubeDeformation(2.0f)).apply(CreeperMinionModel.BABY_TRANSFORMER));
        context.registerLayerDefinition(ModelLayerLocations.CREEPER_MINION_SHOULDER, () -> CreeperModel.createBodyLayer((CubeDeformation)new CubeDeformation(0.0f)).apply(CreeperMinionModel.BABY_TRANSFORMER));
        context.registerLayerDefinition(ModelLayerLocations.CREEPER_MINION_SHOULDER_ARMOR, () -> CreeperModel.createBodyLayer((CubeDeformation)new CubeDeformation(2.0f)).apply(CreeperMinionModel.BABY_TRANSFORMER));
        context.registerLayerDefinition(ModelLayerLocations.ENDERSOUL_CLONE, EndermanModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.ENDERSOUL_FRAGMENT, EndersoulFragmentModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.ENDERSOUL_HAND_LEFT, () -> EndersoulHandModel.createBodyLayer(false));
        context.registerLayerDefinition(ModelLayerLocations.ENDERSOUL_HAND_RIGHT, () -> EndersoulHandModel.createBodyLayer(true));
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_ARROW, MutantArrowModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_CREEPER, () -> MutantCreeperModel.createBodyLayer(new CubeDeformation(0.0f)));
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_CREEPER_ARMOR, () -> MutantCreeperModel.createBodyLayer(new CubeDeformation(2.0f)));
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_CROSSBOW, MutantCrossbowModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_ENDERMAN, MutantEndermanModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.ENDERMAN_CLONE, EndermanModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_SKELETON, MutantSkeletonModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_SKELETON_PART, MutantSkeletonPartModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_SKELETON_PART_SPINE, () -> {
            MeshDefinition mesh = new MeshDefinition();
            PartDefinition root = mesh.getRoot();
            MutantSkeletonModel.Spine.createSpineLayer(root, -1);
            return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
        });
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_SNOW_GOLEM, () -> MutantSnowGolemModel.createBodyLayer(128, 64));
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_SNOW_GOLEM_HEAD, () -> MutantSnowGolemModel.createBodyLayer(64, 32));
        context.registerLayerDefinition(ModelLayerLocations.MUTANT_ZOMBIE, MutantZombieModel::createBodyLayer);
        context.registerLayerDefinition(ModelLayerLocations.SPIDER_PIG, () -> SpiderPigModel.createBodyLayer());
        context.registerLayerDefinition(ModelLayerLocations.SPIDER_PIG_BABY, () -> SpiderPigModel.createBodyLayer().apply(SpiderPigModel.BABY_TRANSFORMER));
        context.registerLayerDefinition(ModelLayerLocations.SPIDER_PIG_SADDLE, () -> SpiderPigModel.createBodyLayer());
        context.registerLayerDefinition(ModelLayerLocations.SPIDER_PIG_BABY_SADDLE, () -> SpiderPigModel.createBodyLayer().apply(SpiderPigModel.BABY_TRANSFORMER));
    }

    public void onRegisterSkullRenderers(SkullRenderersContext context) {
        context.registerSkullRenderer(ModRegistry.MUTANT_SKELETON_SKULL_TYPE, MutantSkeletonRenderer.TEXTURE_LOCATION, entityModelSet -> new SkullModel(entityModelSet.bakeLayer(ModelLayerLocations.MUTANT_SKELETON_SKULL)));
    }

    public void onRegisterEntitySpectatorShaders(EntitySpectatorShadersContext context) {
        context.registerSpectatorShader((EntityType)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.value(), ResourceLocationHelper.withDefaultNamespace((String)"shaders/post/creeper.json"));
        context.registerSpectatorShader((EntityType)ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE.value(), ResourceLocationHelper.withDefaultNamespace((String)"shaders/post/creeper.json"));
        context.registerSpectatorShader((EntityType)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.value(), ResourceLocationHelper.withDefaultNamespace((String)"shaders/post/invert.json"));
        context.registerSpectatorShader((EntityType)ModEntityTypes.MUTANT_ENDERMAN_ENTITY_TYPE.value(), ResourceLocationHelper.withDefaultNamespace((String)"shaders/post/invert.json"));
    }

    public void onRegisterRenderPipelines(RenderPipelinesContext context) {
        context.registerRenderPipeline(ModRenderType.ENERGY_SWIRL_RENDER_PIPELINE);
    }
}

