/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.animation;

import fuzs.mutantmonsters.client.animation.Transform;
import fuzs.mutantmonsters.client.renderer.entity.state.AnimatedEntityRenderState;
import fuzs.mutantmonsters.world.entity.animation.EntityAnimation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public class Animator {
    private int tempTick;
    private int prevTempTick;
    private boolean correctAnim;
    private AnimatedEntityRenderState renderState;
    private final Map<ModelPart, Transform> transformMap = new HashMap<ModelPart, Transform>();
    private final Map<ModelPart, Transform> prevTransformMap = new HashMap<ModelPart, Transform>();

    public AnimatedEntityRenderState getRenderState() {
        return this.renderState;
    }

    public void update(AnimatedEntityRenderState renderState) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = false;
        this.renderState = renderState;
        this.transformMap.clear();
        this.prevTransformMap.clear();
    }

    public boolean setAnimation(EntityAnimation animation) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = this.renderState.animation == animation;
        return this.correctAnim;
    }

    public void startPhase(int duration) {
        if (this.correctAnim) {
            this.prevTempTick = this.tempTick;
            this.tempTick += duration;
        }
    }

    public void setStationaryPhase(int duration) {
        this.startPhase(duration);
        this.endPhase(true);
    }

    public void resetPhase(int duration) {
        this.startPhase(duration);
        this.endPhase();
    }

    public void rotate(ModelPart box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).getRotation().add(x, y, z);
        }
    }

    public void move(ModelPart box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).getOffset().add(x, y, z);
        }
    }

    private Transform getTransform(ModelPart box) {
        return this.transformMap.computeIfAbsent(box, b -> new Transform());
    }

    public void endPhase() {
        this.endPhase(false);
    }

    private void endPhase(boolean stationary) {
        if (this.correctAnim) {
            float animTick = this.renderState.animationTime;
            if (animTick >= (float)this.prevTempTick && animTick < (float)this.tempTick) {
                if (stationary) {
                    for (ModelPart modelPart : this.prevTransformMap.keySet()) {
                        Transform transform = this.prevTransformMap.get(modelPart);
                        transform.rotate(modelPart, 1.0f);
                        transform.offset(modelPart, 1.0f);
                    }
                } else {
                    Transform transform;
                    ModelPart model;
                    ModelPart modelPart;
                    float tick = (animTick - (float)this.prevTempTick) / (float)(this.tempTick - this.prevTempTick);
                    float inc = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
                    float dec = 1.0f - inc;
                    Iterator<ModelPart> iterator = this.prevTransformMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        model = modelPart = iterator.next();
                        transform = this.prevTransformMap.get(model);
                        transform.rotate(model, dec);
                        transform.offset(model, dec);
                    }
                    iterator = this.transformMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        model = modelPart = iterator.next();
                        transform = this.transformMap.get(model);
                        transform.rotate(model, inc);
                        transform.offset(model, inc);
                    }
                }
            }
            if (!stationary) {
                this.prevTransformMap.clear();
                this.prevTransformMap.putAll(this.transformMap);
                this.transformMap.clear();
            }
        }
    }

    public static void addRotationAngle(ModelPart modelPart, float x, float y, float z) {
        modelPart.xRot += x;
        modelPart.yRot += y;
        modelPart.zRot += z;
    }

    public static void resetAngles(ModelPart ... modelParts) {
        for (ModelPart box : modelParts) {
            Animator.resetAngles(box);
        }
    }

    public static void resetAngles(ModelPart modelPart) {
        modelPart.xRot = 0.0f;
        modelPart.yRot = 0.0f;
        modelPart.zRot = 0.0f;
    }

    public static void setScale(ModelPart modelPart, float scale) {
        modelPart.yScale = modelPart.zScale = scale;
        modelPart.xScale = modelPart.zScale;
    }
}

