/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.gui.screens;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.network.client.ServerboundCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.ServerboundCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class CreeperMinionTrackerScreen
extends Screen {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/gui/creeper_minion_tracker.png");
    public static final Component HEALTH_COMPONENT = CreeperMinionTrackerScreen.createComponent("health");
    public static final Component EXPLOSION_COMPONENT = CreeperMinionTrackerScreen.createComponent("explosion");
    public static final Component BLAST_RADIUS_COMPONENT = CreeperMinionTrackerScreen.createComponent("blast_radius");
    public static final Component CONTINUOUS_EXPLOSION_COMPONENT = CreeperMinionTrackerScreen.createComponent("explosion.continuous");
    public static final Component ONE_TIME_EXPLOSION_COMPONENT = CreeperMinionTrackerScreen.createComponent("explosion.one_time");
    public static final Component SHOW_NAME_COMPONENT = CreeperMinionTrackerScreen.createComponent("show_name");
    public static final Component DESTROY_BLOCKS_COMPONENT = CreeperMinionTrackerScreen.createComponent("destroys_blocks");
    public static final Component RIDE_ON_SHOULDER_COMPONENT = CreeperMinionTrackerScreen.createComponent("ride_on_shoulder");
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("0.0"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private final CreeperMinion creeperMinion;
    private int leftPos;
    private int topPos;
    private EditBox name;
    private boolean canRideOnShoulder;
    private boolean canDestroyBlocks;
    private boolean alwaysShowName;
    private int titleLabelX;
    private int titleLabelY;

    public CreeperMinionTrackerScreen(CreeperMinion creeperMinion) {
        super(creeperMinion.getType().getDescription());
        this.creeperMinion = creeperMinion;
    }

    static Component createComponent(String translationKey) {
        return Component.translatable((String)("gui.mutantmonsters.creeper_minion_tracker." + translationKey));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, -12566464, false);
        this.name.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, HEALTH_COMPONENT, this.leftPos + 13, this.topPos + 31, -12566464, false);
        guiGraphics.drawString(this.font, EXPLOSION_COMPONENT, this.leftPos + 13, this.topPos + 51, -12566464, false);
        guiGraphics.drawString(this.font, BLAST_RADIUS_COMPONENT, this.leftPos + 13, this.topPos + 71, -12566464, false);
        guiGraphics.drawCenteredString(this.font, String.format("%s / %s", DECIMAL_FORMAT.format(this.creeperMinion.getHealth()), DECIMAL_FORMAT.format(this.creeperMinion.getMaxHealth())), this.leftPos + this.imageWidth / 2 + 38, this.topPos + 31, -1);
        guiGraphics.drawCenteredString(this.font, this.creeperMinion.canExplodeContinuously() ? CONTINUOUS_EXPLOSION_COMPONENT : ONE_TIME_EXPLOSION_COMPONENT, this.leftPos + this.imageWidth / 2 + 38, this.topPos + 51, -1);
        guiGraphics.drawCenteredString(this.font, DECIMAL_FORMAT.format(this.creeperMinion.getExplosionRadius()), this.leftPos + this.imageWidth / 2 + 38, this.topPos + 71, -1);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        return this.name.keyPressed(keyCode, scanCode, modifiers) || this.name.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void init() {
        this.canDestroyBlocks = this.creeperMinion.canDestroyBlocks();
        this.alwaysShowName = this.creeperMinion.isCustomNameVisible();
        this.canRideOnShoulder = this.creeperMinion.canRideOnShoulder();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.name = new EditBox(this.font, this.leftPos + 5, this.topPos - 24, this.imageHeight, 20, (Component)Component.empty());
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setMaxLength(50);
        this.name.setResponder(this::onNameChanged);
        this.name.setValue(this.creeperMinion.getName().getString());
        this.addWidget((GuiEventListener)this.name);
        int buttonWidth = this.imageWidth / 2 - 10;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CreeperMinionTrackerScreen.onOffComponent(DESTROY_BLOCKS_COMPONENT, this.canDestroyBlocks), button -> {
            this.canDestroyBlocks = !this.canDestroyBlocks;
            MessageSender.broadcast((Message)new ServerboundCreeperMinionTrackerMessage(this.creeperMinion.getId(), ServerboundCreeperMinionTrackerMessage.DataType.CAN_DESTROY_BLOCKS, this.canDestroyBlocks));
            button.setMessage(CreeperMinionTrackerScreen.onOffComponent(DESTROY_BLOCKS_COMPONENT, this.canDestroyBlocks));
        }).bounds(this.leftPos + 8, this.topPos + this.imageHeight - 75, buttonWidth * 2 + 4, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CreeperMinionTrackerScreen.onOffComponent(SHOW_NAME_COMPONENT, this.alwaysShowName), button -> {
            this.alwaysShowName = !this.alwaysShowName;
            MessageSender.broadcast((Message)new ServerboundCreeperMinionTrackerMessage(this.creeperMinion.getId(), ServerboundCreeperMinionTrackerMessage.DataType.IS_CUSTOM_NAME_VISIBLE, this.alwaysShowName));
            button.setMessage(CreeperMinionTrackerScreen.onOffComponent(SHOW_NAME_COMPONENT, this.alwaysShowName));
        }).bounds(this.leftPos + 8, this.topPos + this.imageHeight - 51, buttonWidth * 2 + 4, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CreeperMinionTrackerScreen.onOffComponent(RIDE_ON_SHOULDER_COMPONENT, this.canRideOnShoulder), button -> {
            this.canRideOnShoulder = !this.canRideOnShoulder;
            MessageSender.broadcast((Message)new ServerboundCreeperMinionTrackerMessage(this.creeperMinion.getId(), ServerboundCreeperMinionTrackerMessage.DataType.CAN_RIDE_ON_SHOULDER, this.canRideOnShoulder));
            button.setMessage(CreeperMinionTrackerScreen.onOffComponent(RIDE_ON_SHOULDER_COMPONENT, this.canRideOnShoulder));
        }).bounds(this.leftPos + 8, this.topPos + this.imageHeight - 27, buttonWidth * 2 + 4, 20).build());
        if (!this.creeperMinion.isOwnedBy((LivingEntity)this.minecraft.player)) {
            this.renderables.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(widget -> {
                widget.active = false;
            });
        }
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY = 6;
    }

    public void tick() {
        if (!this.creeperMinion.isAlive()) {
            this.minecraft.player.closeContainer();
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE_LOCATION, this.leftPos + 15, this.topPos + 16, 0.0f, 166.0f, 146, 5, 256, 256);
        float healthProgress = Mth.clamp((float)(this.creeperMinion.getHealth() / this.creeperMinion.getMaxHealth()), (float)0.0f, (float)1.0f);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE_LOCATION, this.leftPos + 15, this.topPos + 16, 0.0f, 171.0f, (int)(healthProgress * 146.0f), 5, 256, 256);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String string = this.name.getValue();
        this.init(minecraft, width, height);
        this.name.setValue(string);
    }

    private void onNameChanged(String input) {
        if (!(input = input.trim()).equals(this.creeperMinion.getName().getString())) {
            this.creeperMinion.setCustomName((Component)Component.literal((String)input));
            MessageSender.broadcast((Message)new ServerboundCreeperMinionNameMessage(this.creeperMinion.getId(), input));
        }
    }

    private static Component onOffComponent(Component component, boolean on) {
        return Component.empty().append(component).append(": ").append(on ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
    }
}

