/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import fuzs.mutantmonsters.client.renderer.entity.state.EndersoulFragmentRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;

public class EndersoulFragmentModel
extends EntityModel<EndersoulFragmentRenderState> {
    private final ModelPart[] sticks = new ModelPart[8];

    public EndersoulFragmentModel(ModelPart root) {
        super(root);
        ModelPart base = root.getChild("base");
        for (int i = 0; i < this.sticks.length; ++i) {
            this.sticks[i] = base.getChild("stick" + i);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition base = root.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        for (int i = 0; i < 8; ++i) {
            CubeListBuilder cubeListBuilder = CubeListBuilder.create().texOffs(0, 0);
            if (i < 4) {
                cubeListBuilder.addBox(-0.5f, -4.0f, -0.5f, 1.0f, 8.0f, 1.0f);
            } else {
                cubeListBuilder.addBox(-0.5f, -6.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.15f));
            }
            base.addOrReplaceChild("stick" + i, cubeListBuilder, PartPose.ZERO);
        }
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(EndersoulFragmentRenderState renderState) {
        super.setupAnim((EntityRenderState)renderState);
        for (int i = 0; i < this.sticks.length; ++i) {
            this.sticks[i].xRot = renderState.stickRotations[i][0];
            this.sticks[i].yRot = renderState.stickRotations[i][1];
            this.sticks[i].zRot = renderState.stickRotations[i][2];
        }
    }
}

