/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import fuzs.mutantmonsters.client.animation.Animator;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class EndersoulHandModel
extends Model {
    private final ModelPart hand;
    private final ModelPart[] finger = new ModelPart[3];
    private final ModelPart[] foreFinger = new ModelPart[3];
    private final ModelPart thumb;
    private final boolean right;

    public EndersoulHandModel(ModelPart root, boolean right) {
        super(root, RenderType::entitySolid);
        this.right = right;
        this.hand = root.getChild("hand");
        for (int i = 0; i < this.finger.length; ++i) {
            this.finger[i] = this.hand.getChild("finger" + i);
            this.foreFinger[i] = this.finger[i].getChild("fore_finger" + i);
        }
        this.thumb = this.hand.getChild("thumb");
    }

    public static LayerDefinition createBodyLayer(boolean right) {
        int i;
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition hand = root.addOrReplaceChild("hand", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)17.5f, (float)0.0f));
        for (i = 0; i < 3; ++i) {
            CubeListBuilder cubeListBuilder = CubeListBuilder.create().texOffs(i * 4, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new CubeDeformation(0.6f)).mirror(!right);
            PartPose partPose = i == 0 ? PartPose.offset((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)-1.0f) : (i == 1 ? PartPose.offset((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)0.0f) : PartPose.offset((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)1.0f));
            hand.addOrReplaceChild("finger" + i, cubeListBuilder, partPose);
        }
        for (i = 0; i < 3; ++i) {
            hand.getChild("finger" + i).addOrReplaceChild("fore_finger" + i, CubeListBuilder.create().texOffs(1 + i * 5, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new CubeDeformation(0.59000003f)).mirror(!right), PartPose.offset((float)0.0f, (float)(0.5f + (float)(i == 1 ? 6 : 5)), (float)0.0f));
        }
        hand.addOrReplaceChild("thumb", CubeListBuilder.create().texOffs(14, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.6f)), PartPose.offset((float)(right ? 0.5f : -0.5f), (float)0.0f, (float)-0.5f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setAngles() {
        Animator.resetAngles(this.hand);
        for (int i = 0; i < this.finger.length; ++i) {
            Animator.resetAngles(this.finger[i]);
            Animator.resetAngles(this.foreFinger[i]);
        }
        Animator.resetAngles(this.thumb);
        if (this.right) {
            this.hand.yRot = -0.3926991f;
            this.finger[0].xRot = -0.2617994f;
            this.finger[1].zRot = 0.17453294f;
            this.finger[2].xRot = 0.2617994f;
            this.foreFinger[0].zRot = -0.2617994f;
            this.foreFinger[1].zRot = -0.3926991f;
            this.foreFinger[2].zRot = -0.2617994f;
            this.thumb.xRot = -0.62831855f;
            this.thumb.zRot = -0.3926991f;
        } else {
            this.hand.yRot = 0.3926991f;
            this.finger[0].xRot = -0.2617994f;
            this.finger[1].zRot = -0.17453294f;
            this.finger[2].xRot = 0.2617994f;
            this.foreFinger[0].zRot = 0.2617994f;
            this.foreFinger[1].zRot = 0.3926991f;
            this.foreFinger[2].zRot = 0.2617994f;
            this.thumb.xRot = -0.62831855f;
            this.thumb.zRot = 0.3926991f;
        }
    }
}

