/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantEndermanRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import java.util.Arrays;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;

public class MutantEndermanModel
extends EntityModel<MutantEndermanRenderState> {
    private final ModelPart pelvis;
    private final ModelPart abdomen;
    private final ModelPart chest;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart mouth;
    private final Arm rightArm;
    private final Arm leftArm;
    private final Arm lowerRightArm;
    private final Arm lowerLeftArm;
    private final ModelPart legJoint1;
    private final ModelPart legJoint2;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart foreLeg1;
    private final ModelPart foreLeg2;

    public MutantEndermanModel(ModelPart modelPart) {
        super(modelPart);
        this.pelvis = modelPart.getChild("pelvis");
        this.abdomen = this.pelvis.getChild("abdomen");
        this.chest = this.abdomen.getChild("chest");
        this.neck = this.chest.getChild("neck");
        this.head = this.neck.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.rightArm = new Arm("right_", this.chest, true);
        this.leftArm = new Arm("left_", this.chest, false);
        this.lowerRightArm = new Arm("lower_right_", this.chest, true);
        this.lowerLeftArm = new Arm("lower_left_", this.chest, false);
        this.legJoint1 = this.abdomen.getChild("leg_joint1");
        this.legJoint2 = this.abdomen.getChild("leg_joint2");
        this.leg1 = this.legJoint1.getChild("leg1");
        this.leg2 = this.legJoint2.getChild("leg2");
        this.foreLeg1 = this.leg1.getChild("fore_leg1");
        this.foreLeg2 = this.leg2.getChild("fore_leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition pelvis = root.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)-15.5f, (float)8.0f));
        PartDefinition abdomen = pelvis.addOrReplaceChild("abdomen", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.0f, -2.0f, 8.0f, 10.0f, 4.0f), PartPose.ZERO);
        PartDefinition chest = abdomen.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(50, 8).addBox(-5.0f, -16.0f, -3.0f, 10.0f, 16.0f, 6.0f), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition neck = chest.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(32, 14).addBox(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)-15.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(0, 14).addBox(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)3.0f));
        head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 24).addBox(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f), PartPose.ZERO);
        Arm.createArmLayer("right_", chest, true, false);
        Arm.createArmLayer("left_", chest, false, false);
        Arm.createArmLayer("lower_right_", chest, true, true);
        Arm.createArmLayer("lower_left_", chest, false, true);
        PartDefinition legJoint1 = abdomen.addOrReplaceChild("leg_joint1", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)-1.5f, (float)0.0f, (float)0.75f));
        PartDefinition legJoint2 = abdomen.addOrReplaceChild("leg_joint2", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)1.5f, (float)0.0f, (float)0.75f));
        PartDefinition leg1 = legJoint1.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 34).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition leg2 = legJoint2.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 34).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        leg1.addOrReplaceChild("fore_leg1", CubeListBuilder.create().texOffs(12, 34).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        leg2.addOrReplaceChild("fore_leg2", CubeListBuilder.create().texOffs(12, 34).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void setupAnim(MutantEndermanRenderState renderState) {
        super.setupAnim((EntityRenderState)renderState);
        this.setupInitialAngles();
        float limbSwing = renderState.walkAnimationPos;
        float limbSwingAmount = renderState.walkAnimationSpeed;
        float ageInTicks = renderState.ageInTicks;
        float netHeadYaw = renderState.yRot;
        float headPitch = renderState.xRot;
        this.animate(renderState, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        Animator.setScale(this.lowerRightArm.arm, renderState.armScale);
        Animator.setScale(this.lowerLeftArm.arm, renderState.armScale);
    }

    private void setupInitialAngles() {
        this.pelvis.y = -15.5f;
        this.abdomen.xRot = 0.31415927f;
        this.chest.xRot = 0.3926991f;
        this.chest.yRot = 0.0f;
        this.chest.zRot = 0.0f;
        this.neck.xRot = 0.19634955f;
        this.neck.zRot = 0.0f;
        this.head.xRot = -0.7853982f;
        this.head.yRot = 0.0f;
        this.head.zRot = 0.0f;
        this.mouth.xRot = 0.0f;
        this.rightArm.setAngles();
        this.leftArm.setAngles();
        this.lowerRightArm.setAngles();
        this.lowerRightArm.arm.xRot += 0.1f;
        this.lowerRightArm.arm.zRot -= 0.2f;
        this.lowerLeftArm.setAngles();
        this.lowerLeftArm.arm.xRot += 0.1f;
        this.lowerLeftArm.arm.zRot += 0.2f;
        this.legJoint1.xRot = 0.0f;
        this.legJoint2.xRot = 0.0f;
        this.leg1.xRot = -0.8975979f;
        this.leg1.yRot = 0.0f;
        this.leg1.zRot = 0.2617994f;
        this.leg2.xRot = -0.8975979f;
        this.leg2.yRot = 0.0f;
        this.leg2.zRot = -0.2617994f;
        this.foreLeg1.xRot = 0.7853982f;
        this.foreLeg1.zRot = -0.1308997f;
        this.foreLeg2.xRot = 0.7853982f;
        this.foreLeg2.zRot = 0.1308997f;
    }

    private void animate(MutantEndermanRenderState renderState, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkSpeed = 0.3f;
        float walkAnim1 = (Mth.sin((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float walkAnim2 = -(Mth.sin((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim3 = (Mth.sin((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim4 = -(Mth.sin((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float[] walkAnim = new float[5];
        Arrays.fill(walkAnim, Mth.sin((float)(limbSwing * walkSpeed)) * limbSwingAmount);
        float breatheAnim = Mth.sin((float)(ageInTicks * 0.15f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        for (int i = 0; i < 4; ++i) {
            if (renderState.heldBlocks[i] == null) continue;
            this.animateHoldBlock(renderState, i);
            int n = i;
            walkAnim[n] = walkAnim[n] * 0.4f;
        }
        if (renderState.animation == MutantEnderman.MELEE_ANIMATION) {
            this.animateMelee(renderState, renderState.activeArm);
            walkAnim[renderState.activeArm] = 0.0f;
        }
        if (renderState.animation == MutantEnderman.THROW_ANIMATION) {
            this.animateThrowBlock(renderState, renderState.activeArm);
        }
        if (renderState.animation == MutantEnderman.SCREAM_ANIMATION) {
            this.animateScream(renderState);
            float scale = 1.0f - Mth.clamp((float)(renderState.animationTime / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        if (renderState.animation == MutantEnderman.TELESMASH_ANIMATION) {
            this.animateTeleSmash(renderState);
        }
        if (renderState.animation == MutantEnderman.DEATH_ANIMATION) {
            this.animateDeath(renderState);
            float scale = 1.0f - Mth.clamp((float)(renderState.deathTime / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        this.head.xRot += facePitch * 0.5f;
        this.head.yRot += faceYaw * 0.7f;
        this.head.zRot -= faceYaw * 0.7f;
        this.neck.xRot += facePitch * 0.3f;
        this.chest.xRot += facePitch * 0.2f;
        this.mouth.xRot += breatheAnim * 0.02f + 0.02f;
        this.neck.xRot -= breatheAnim * 0.02f;
        this.rightArm.arm.zRot += breatheAnim * 0.004f;
        this.leftArm.arm.zRot -= breatheAnim * 0.004f;
        for (ModelPart modelPart : this.rightArm.finger) {
            modelPart.zRot += breatheAnim * 0.05f;
        }
        this.rightArm.thumb.zRot -= breatheAnim * 0.05f;
        for (ModelPart modelPart : this.leftArm.finger) {
            modelPart.zRot -= breatheAnim * 0.05f;
        }
        this.leftArm.thumb.zRot += breatheAnim * 0.05f;
        this.lowerRightArm.arm.zRot += breatheAnim * 0.002f;
        this.lowerLeftArm.arm.zRot -= breatheAnim * 0.002f;
        for (ModelPart modelPart : this.lowerRightArm.finger) {
            modelPart.zRot += breatheAnim * 0.02f;
        }
        this.lowerRightArm.thumb.zRot -= breatheAnim * 0.02f;
        for (ModelPart modelPart : this.lowerLeftArm.finger) {
            modelPart.zRot -= breatheAnim * 0.02f;
        }
        this.lowerLeftArm.thumb.zRot += breatheAnim * 0.02f;
        this.pelvis.y -= Math.abs(walkAnim[4]);
        this.chest.yRot -= walkAnim[4] * 0.06f;
        this.rightArm.arm.xRot -= walkAnim[0] * 0.6f;
        this.leftArm.arm.xRot += walkAnim[1] * 0.6f;
        this.rightArm.foreArm.xRot -= walkAnim[0] * 0.2f;
        this.leftArm.foreArm.xRot += walkAnim[1] * 0.2f;
        this.lowerRightArm.arm.xRot -= walkAnim[2] * 0.3f;
        this.lowerLeftArm.arm.xRot += walkAnim[3] * 0.3f;
        this.lowerRightArm.foreArm.xRot -= walkAnim[2] * 0.1f;
        this.lowerLeftArm.foreArm.xRot += walkAnim[3] * 0.1f;
        this.legJoint1.xRot += walkAnim1 * 0.6f;
        this.legJoint2.xRot += walkAnim2 * 0.6f;
        this.foreLeg1.xRot += walkAnim3 * 0.3f;
        this.foreLeg2.xRot += walkAnim4 * 0.3f;
    }

    private void animateHoldBlock(MutantEndermanRenderState renderState, int armId) {
        float animationProgress = renderState.heldBlockTicks[armId] / 10.0f;
        float rotationAmount = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
        if (armId == 0) {
            this.rightArm.arm.zRot += rotationAmount * 0.8f;
            this.rightArm.foreArm.zRot += rotationAmount * 0.6f;
            this.rightArm.hand.yRot += rotationAmount * 0.8f;
            this.rightArm.finger[0].xRot += -rotationAmount * 0.2f;
            this.rightArm.finger[2].xRot += rotationAmount * 0.2f;
            for (ModelPart modelPart : this.rightArm.finger) {
                modelPart.zRot += rotationAmount * 0.6f;
            }
            this.rightArm.thumb.zRot += -rotationAmount * 0.4f;
        } else if (armId == 1) {
            this.leftArm.arm.zRot += -rotationAmount * 0.8f;
            this.leftArm.foreArm.zRot += -rotationAmount * 0.6f;
            this.leftArm.hand.yRot += -rotationAmount * 0.8f;
            this.leftArm.finger[0].xRot += -rotationAmount * 0.2f;
            this.leftArm.finger[2].xRot += rotationAmount * 0.2f;
            for (ModelPart modelPart : this.leftArm.finger) {
                modelPart.zRot += -rotationAmount * 0.6f;
            }
            this.leftArm.thumb.zRot += rotationAmount * 0.4f;
        } else if (armId == 2) {
            this.lowerRightArm.arm.zRot += rotationAmount * 0.5f;
            this.lowerRightArm.foreArm.zRot += rotationAmount * 0.4f;
            this.lowerRightArm.hand.yRot += rotationAmount * 0.4f;
            this.lowerRightArm.finger[0].xRot += -rotationAmount * 0.2f;
            this.lowerRightArm.finger[2].xRot += rotationAmount * 0.2f;
            for (ModelPart modelPart : this.lowerRightArm.finger) {
                modelPart.zRot += rotationAmount * 0.6f;
            }
            this.lowerRightArm.thumb.zRot += -rotationAmount * 0.4f;
        } else if (armId == 3) {
            this.lowerLeftArm.arm.zRot += -rotationAmount * 0.5f;
            this.lowerLeftArm.foreArm.zRot += -rotationAmount * 0.4f;
            this.lowerLeftArm.hand.yRot += -rotationAmount * 0.4f;
            this.lowerLeftArm.finger[0].xRot += -rotationAmount * 0.2f;
            this.lowerLeftArm.finger[2].xRot += rotationAmount * 0.2f;
            for (ModelPart modelPart : this.lowerLeftArm.finger) {
                modelPart.zRot += -rotationAmount * 0.6f;
            }
            this.lowerLeftArm.thumb.zRot += rotationAmount * 0.4f;
        }
    }

    private void animateMelee(MutantEndermanRenderState renderState, int armId) {
        float isRightArm = (armId & 1) == 0 ? 1.0f : -1.0f;
        Arm arm = this.getArmFromId(armId);
        if (renderState.animationTime < 2.0f) {
            float animationProgress = renderState.animationTime / 2.0f;
            float rotationAmount = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
            arm.arm.xRot += rotationAmount * 0.2f;
            arm.finger[0].zRot += rotationAmount * 0.3f * isRightArm;
            arm.finger[1].zRot += rotationAmount * 0.3f * isRightArm;
            arm.finger[2].zRot += rotationAmount * 0.3f * isRightArm;
            arm.foreFinger[0].zRot += -rotationAmount * 0.5f * isRightArm;
            arm.foreFinger[1].zRot += -rotationAmount * 0.5f * isRightArm;
            arm.foreFinger[2].zRot += -rotationAmount * 0.5f * isRightArm;
        } else if (renderState.animationTime < 5.0f) {
            float animationProgress = (renderState.animationTime - 2.0f) / 3.0f;
            float rotationAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
            this.chest.yRot += -f1 * 0.1f * isRightArm;
            arm.arm.xRot += rotationAmount * 1.1f - 1.1f;
            arm.foreArm.xRot += -rotationAmount * 0.4f;
            arm.finger[0].zRot += 0.3f * isRightArm;
            arm.finger[1].zRot += 0.3f * isRightArm;
            arm.finger[2].zRot += 0.3f * isRightArm;
            arm.foreFinger[0].zRot += -0.5f * isRightArm;
            arm.foreFinger[1].zRot += -0.5f * isRightArm;
            arm.foreFinger[2].zRot += -0.5f * isRightArm;
        } else if (renderState.animationTime < 6.0f) {
            this.chest.yRot += -0.1f * isRightArm;
            arm.arm.xRot += -1.1f;
            arm.foreArm.xRot += -0.4f;
            arm.finger[0].zRot += 0.3f * isRightArm;
            arm.finger[1].zRot += 0.3f * isRightArm;
            arm.finger[2].zRot += 0.3f * isRightArm;
            arm.foreFinger[0].zRot += -0.5f * isRightArm;
            arm.foreFinger[1].zRot += -0.5f * isRightArm;
            arm.foreFinger[2].zRot += -0.5f * isRightArm;
        } else if (renderState.animationTime < 10.0f) {
            float animationProgress = (renderState.animationTime - 6.0f) / 4.0f;
            float rotationAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
            this.chest.yRot += -rotationAmount * 0.1f * isRightArm;
            arm.arm.xRot += -rotationAmount * 1.1f;
            arm.foreArm.xRot += -rotationAmount * 0.4f;
            arm.finger[0].zRot += rotationAmount * 0.3f * isRightArm;
            arm.finger[1].zRot += rotationAmount * 0.3f * isRightArm;
            arm.finger[2].zRot += rotationAmount * 0.3f * isRightArm;
            arm.foreFinger[0].zRot += -rotationAmount * 0.5f * isRightArm;
            arm.foreFinger[1].zRot += -rotationAmount * 0.5f * isRightArm;
            arm.foreFinger[2].zRot += -rotationAmount * 0.5f * isRightArm;
        }
    }

    private void animateThrowBlock(MutantEndermanRenderState renderState, int armId) {
        switch (armId) {
            case 0: {
                if (renderState.animationTime < 4.0f) {
                    float animationProgress = renderState.animationTime / 4.0f;
                    float cosSwingAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
                    float sinSwingAmount = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
                    this.rightArm.arm.xRot += -sinSwingAmount * 1.5f;
                    this.rightArm.arm.zRot += cosSwingAmount * 0.8f;
                    this.rightArm.foreArm.zRot += cosSwingAmount * 0.6f;
                    this.rightArm.hand.yRot += cosSwingAmount * 0.8f;
                    this.rightArm.finger[0].xRot += -cosSwingAmount * 0.2f;
                    this.rightArm.finger[2].xRot += cosSwingAmount * 0.2f;
                    for (ModelPart finger : this.rightArm.finger) {
                        finger.zRot += cosSwingAmount * 0.6f;
                    }
                    this.rightArm.thumb.zRot += -cosSwingAmount * 0.4f;
                    break;
                }
                if (renderState.animationTime < 7.0f) {
                    this.rightArm.arm.xRot += -1.5f;
                    break;
                }
                if (!(renderState.animationTime < 14.0f)) break;
                float animationProgress = (renderState.animationTime - 7.0f) / 7.0f;
                float cosSwingAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
                this.rightArm.arm.xRot += -cosSwingAmount * 1.5f;
                break;
            }
            case 1: {
                if (renderState.animationTime < 4.0f) {
                    float animationProgress = renderState.animationTime / 4.0f;
                    float cosSwingAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
                    float sinSwingAmount = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
                    this.leftArm.arm.xRot += -sinSwingAmount * 1.5f;
                    this.leftArm.arm.zRot += -cosSwingAmount * 0.8f;
                    this.leftArm.foreArm.zRot += -cosSwingAmount * 0.6f;
                    this.leftArm.hand.yRot += -cosSwingAmount * 0.8f;
                    this.leftArm.finger[0].xRot += -cosSwingAmount * 0.2f;
                    this.leftArm.finger[2].xRot += cosSwingAmount * 0.2f;
                    for (ModelPart finger : this.leftArm.finger) {
                        finger.zRot += -cosSwingAmount * 0.6f;
                    }
                    this.leftArm.thumb.zRot += cosSwingAmount * 0.4f;
                    break;
                }
                if (renderState.animationTime < 7.0f) {
                    this.leftArm.arm.xRot += -1.5f;
                    break;
                }
                if (!(renderState.animationTime < 14.0f)) break;
                float animationProgress = (renderState.animationTime - 7.0f) / 7.0f;
                float cosSwingAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
                this.leftArm.arm.xRot += -cosSwingAmount * 1.5f;
                break;
            }
            case 2: {
                if (renderState.animationTime < 4.0f) {
                    float animationProgress = renderState.animationTime / 4.0f;
                    float cosSwingAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
                    float sinSwingAmount = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
                    this.lowerRightArm.arm.xRot += -sinSwingAmount * 1.5f;
                    this.lowerRightArm.arm.zRot += cosSwingAmount * 0.5f;
                    this.lowerRightArm.foreArm.zRot += cosSwingAmount * 0.4f;
                    this.lowerRightArm.hand.yRot += cosSwingAmount * 0.4f;
                    this.lowerRightArm.finger[0].xRot += -cosSwingAmount * 0.2f;
                    this.lowerRightArm.finger[2].xRot += cosSwingAmount * 0.2f;
                    for (ModelPart finger : this.lowerRightArm.finger) {
                        finger.zRot += cosSwingAmount * 0.6f;
                    }
                    this.lowerRightArm.thumb.zRot += -cosSwingAmount * 0.4f;
                    break;
                }
                if (renderState.animationTime < 7.0f) {
                    this.lowerRightArm.arm.xRot += -1.5f;
                    break;
                }
                if (!(renderState.animationTime < 14.0f)) break;
                float animationProgress = (renderState.animationTime - 7.0f) / 7.0f;
                float cosSwingAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.xRot += -cosSwingAmount * 1.5f;
                break;
            }
            case 3: {
                if (renderState.animationTime < 4.0f) {
                    float animationProgress = renderState.animationTime / 4.0f;
                    float cosSwingAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
                    float sinSwingAmount = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
                    this.lowerLeftArm.arm.xRot += -sinSwingAmount * 1.5f;
                    this.lowerLeftArm.arm.zRot += -cosSwingAmount * 0.5f;
                    this.lowerLeftArm.foreArm.zRot += -cosSwingAmount * 0.4f;
                    this.lowerLeftArm.hand.yRot += -cosSwingAmount * 0.4f;
                    this.lowerLeftArm.finger[0].xRot += -cosSwingAmount * 0.2f;
                    this.lowerLeftArm.finger[2].xRot += cosSwingAmount * 0.2f;
                    for (ModelPart finger : this.lowerLeftArm.finger) {
                        finger.zRot += -cosSwingAmount * 0.6f;
                    }
                    this.lowerLeftArm.thumb.zRot += cosSwingAmount * 0.4f;
                    break;
                }
                if (renderState.animationTime < 7.0f) {
                    this.lowerLeftArm.arm.xRot += -1.5f;
                    break;
                }
                if (!(renderState.animationTime < 14.0f)) break;
                float animationProgress = (renderState.animationTime - 7.0f) / 7.0f;
                float cosSwingAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.xRot += -cosSwingAmount * 1.5f;
            }
        }
    }

    private void animateScream(MutantEndermanRenderState renderState) {
        if (renderState.animationTime < 35.0f) {
            int i;
            float animationProgress = renderState.animationTime / 35.0f;
            float rotationAmount = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
            this.abdomen.xRot += rotationAmount * 0.3f;
            this.chest.xRot += rotationAmount * 0.4f;
            this.neck.xRot += rotationAmount * 0.2f;
            this.head.xRot += rotationAmount * 0.3f;
            this.rightArm.arm.xRot += -rotationAmount * 0.6f;
            this.rightArm.arm.yRot += rotationAmount * 0.4f;
            this.rightArm.foreArm.xRot += -rotationAmount * 0.8f;
            this.rightArm.hand.zRot += -rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].zRot += rotationAmount * 0.3f;
                this.rightArm.foreFinger[i].zRot += -rotationAmount * 0.5f;
            }
            this.leftArm.arm.xRot += -rotationAmount * 0.6f;
            this.leftArm.arm.yRot += -rotationAmount * 0.4f;
            this.leftArm.foreArm.xRot += -rotationAmount * 0.8f;
            this.leftArm.hand.zRot += rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].zRot += -rotationAmount * 0.3f;
                this.leftArm.foreFinger[i].zRot += rotationAmount * 0.5f;
            }
            this.lowerRightArm.arm.xRot += -rotationAmount * 0.4f;
            this.lowerRightArm.arm.yRot += rotationAmount * 0.2f;
            this.lowerRightArm.foreArm.xRot += -rotationAmount * 0.8f;
            this.lowerRightArm.hand.zRot += -rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].zRot += rotationAmount * 0.3f;
                this.lowerRightArm.foreFinger[i].zRot += -rotationAmount * 0.5f;
            }
            this.lowerLeftArm.arm.xRot += -rotationAmount * 0.4f;
            this.lowerLeftArm.arm.yRot += -rotationAmount * 0.2f;
            this.lowerLeftArm.foreArm.xRot += -rotationAmount * 0.8f;
            this.lowerLeftArm.hand.zRot += rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].zRot += -rotationAmount * 0.3f;
                this.lowerLeftArm.foreFinger[i].zRot += rotationAmount * 0.5f;
            }
        } else if (renderState.animationTime < 40.0f) {
            int i;
            this.abdomen.xRot += 0.3f;
            this.chest.xRot += 0.4f;
            this.neck.xRot += 0.2f;
            this.head.xRot += 0.3f;
            this.rightArm.arm.xRot += -0.6f;
            this.rightArm.arm.yRot += 0.4f;
            this.rightArm.foreArm.xRot += -0.8f;
            this.rightArm.hand.zRot += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].zRot += 0.3f;
                this.rightArm.foreFinger[i].zRot += -0.5f;
            }
            this.leftArm.arm.xRot += -0.6f;
            this.leftArm.arm.yRot += -0.4f;
            this.leftArm.foreArm.xRot += -0.8f;
            this.leftArm.hand.zRot += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].zRot += -0.3f;
                this.leftArm.foreFinger[i].zRot += 0.5f;
            }
            this.lowerRightArm.arm.xRot += -0.4f;
            this.lowerRightArm.arm.yRot += 0.2f;
            this.lowerRightArm.foreArm.xRot += -0.8f;
            this.lowerRightArm.hand.zRot += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].zRot += 0.3f;
                this.lowerRightArm.foreFinger[i].zRot += -0.5f;
            }
            this.lowerLeftArm.arm.xRot += -0.4f;
            this.lowerLeftArm.arm.yRot += -0.2f;
            this.lowerLeftArm.foreArm.xRot += -0.8f;
            this.lowerLeftArm.hand.zRot += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].zRot += -0.3f;
                this.lowerLeftArm.foreFinger[i].zRot += 0.5f;
            }
        } else if (renderState.animationTime < 44.0f) {
            int i;
            float animationProgress = (renderState.animationTime - 40.0f) / 4.0f;
            float rotationAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
            this.abdomen.xRot += -rotationAmount * 0.1f + 0.4f;
            this.chest.xRot += rotationAmount * 0.1f + 0.3f;
            this.chest.zRot += f1 * 0.5f;
            this.neck.xRot += rotationAmount * 0.2f;
            this.neck.zRot += f1 * 0.2f;
            this.head.xRot += rotationAmount * 1.2f - 0.8f;
            this.head.zRot += f1 * 0.4f;
            this.mouth.xRot += f1 * 0.6f;
            this.rightArm.arm.xRot += -rotationAmount * 0.6f;
            this.rightArm.arm.yRot += 0.4f;
            this.rightArm.foreArm.xRot += -rotationAmount * 0.8f;
            this.rightArm.hand.zRot += -rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].zRot += rotationAmount * 0.3f;
                this.rightArm.foreFinger[i].zRot += -rotationAmount * 0.5f;
            }
            this.leftArm.arm.xRot += -rotationAmount * 0.6f;
            this.leftArm.arm.yRot += -0.4f;
            this.leftArm.foreArm.xRot += -rotationAmount * 0.8f;
            this.leftArm.hand.zRot += rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].zRot += -rotationAmount * 0.3f;
                this.leftArm.foreFinger[i].zRot += rotationAmount * 0.5f;
            }
            this.lowerRightArm.arm.xRot += -rotationAmount * 0.4f;
            this.lowerRightArm.arm.yRot += -rotationAmount * 0.1f + 0.3f;
            this.lowerRightArm.foreArm.xRot += -rotationAmount * 0.8f;
            this.lowerRightArm.hand.zRot += -rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].zRot += rotationAmount * 0.3f;
                this.lowerRightArm.foreFinger[i].zRot += -rotationAmount * 0.5f;
            }
            this.lowerLeftArm.arm.xRot += -rotationAmount * 0.4f;
            this.lowerLeftArm.arm.yRot += rotationAmount * 0.1f - 0.3f;
            this.lowerLeftArm.foreArm.xRot += -rotationAmount * 0.8f;
            this.lowerLeftArm.hand.zRot += rotationAmount * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].zRot += -rotationAmount * 0.3f;
                this.lowerLeftArm.foreFinger[i].zRot += rotationAmount * 0.5f;
            }
            this.leg1.zRot += f1 * 0.1f;
            this.leg2.zRot += -f1 * 0.1f;
        } else if (renderState.animationTime < 155.0f) {
            float animationProgress = (renderState.animationTime - 44.0f) / 111.0f;
            float rotationAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
            this.abdomen.xRot += 0.4f;
            this.chest.xRot += 0.3f;
            this.chest.zRot += rotationAmount - 0.5f;
            this.neck.zRot += rotationAmount * 0.4f - 0.2f;
            this.head.xRot += -0.8f;
            this.head.zRot += rotationAmount * 0.8f - 0.4f;
            this.mouth.xRot += 0.6f;
            this.rightArm.arm.yRot += 0.4f;
            this.leftArm.arm.yRot += -0.4f;
            this.lowerRightArm.arm.yRot += 0.3f;
            this.lowerLeftArm.arm.yRot += -0.3f;
            this.leg1.zRot += 0.1f;
            this.leg2.zRot += -0.1f;
        } else if (renderState.animationTime < 160.0f) {
            float animationProgress = (renderState.animationTime - 155.0f) / 5.0f;
            float rotationAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
            this.abdomen.xRot += rotationAmount * 0.4f;
            this.chest.xRot += rotationAmount * 0.3f;
            this.chest.zRot += -rotationAmount * 0.5f;
            this.neck.zRot += -rotationAmount * 0.2f;
            this.head.xRot += -rotationAmount * 0.8f;
            this.head.zRot += -rotationAmount * 0.4f;
            this.mouth.xRot += rotationAmount * 0.6f;
            this.rightArm.arm.yRot += rotationAmount * 0.4f;
            this.leftArm.arm.yRot += -rotationAmount * 0.4f;
            this.lowerRightArm.arm.yRot += rotationAmount * 0.3f;
            this.lowerLeftArm.arm.yRot += -rotationAmount * 0.3f;
            this.leg1.zRot += rotationAmount * 0.1f;
            this.leg2.zRot += -rotationAmount * 0.1f;
        }
    }

    private void animateTeleSmash(MutantEndermanRenderState renderState) {
        if (renderState.animationTime < 18.0f) {
            float animationProgress = renderState.animationTime / 18.0f;
            float rotationAmount = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
            this.chest.xRot += -rotationAmount * 0.3f;
            this.rightArm.arm.yRot += rotationAmount * 0.2f;
            this.rightArm.arm.zRot += rotationAmount * 0.8f;
            this.rightArm.hand.yRot += rotationAmount * 1.7f;
            this.leftArm.arm.yRot += -rotationAmount * 0.2f;
            this.leftArm.arm.zRot += -rotationAmount * 0.8f;
            this.leftArm.hand.yRot += -rotationAmount * 1.7f;
            this.lowerRightArm.arm.yRot += rotationAmount * 0.2f;
            this.lowerRightArm.arm.zRot += rotationAmount * 0.6f;
            this.lowerRightArm.hand.yRot += rotationAmount * 1.7f;
            this.lowerLeftArm.arm.yRot += -rotationAmount * 0.2f;
            this.lowerLeftArm.arm.zRot += -rotationAmount * 0.6f;
            this.lowerLeftArm.hand.yRot += -rotationAmount * 1.7f;
        } else if (renderState.animationTime < 20.0f) {
            float animationProgress = (renderState.animationTime - 18.0f) / 2.0f;
            float rotationAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
            this.chest.xRot += -rotationAmount * 0.3f;
            this.rightArm.arm.xRot += -f1 * 0.8f;
            this.rightArm.arm.yRot += 0.2f;
            this.rightArm.arm.zRot += 0.8f;
            this.rightArm.hand.yRot += 1.0f;
            this.leftArm.arm.xRot += -f1 * 0.8f;
            this.leftArm.arm.yRot += -0.2f;
            this.leftArm.arm.zRot += -0.8f;
            this.leftArm.hand.yRot += -1.7f;
            this.lowerRightArm.arm.xRot += -f1 * 0.9f;
            this.lowerRightArm.arm.yRot += 0.2f;
            this.lowerRightArm.arm.zRot += 0.6f;
            this.lowerRightArm.hand.yRot += 1.0f;
            this.lowerLeftArm.arm.xRot += -f1 * 0.9f;
            this.lowerLeftArm.arm.yRot += -0.2f;
            this.lowerLeftArm.arm.zRot += -0.6f;
            this.lowerLeftArm.hand.yRot += -1.7f;
        } else if (renderState.animationTime < 24.0f) {
            this.rightArm.arm.xRot += -0.8f;
            this.rightArm.arm.yRot += 0.2f;
            this.rightArm.arm.zRot += 0.8f;
            this.rightArm.hand.yRot += 1.0f;
            this.leftArm.arm.xRot += -0.8f;
            this.leftArm.arm.yRot += -0.2f;
            this.leftArm.arm.zRot += -0.8f;
            this.leftArm.hand.yRot += -1.7f;
            this.lowerRightArm.arm.xRot += -0.9f;
            this.lowerRightArm.arm.yRot += 0.2f;
            this.lowerRightArm.arm.zRot += 0.6f;
            this.lowerRightArm.hand.yRot += 1.0f;
            this.lowerLeftArm.arm.xRot += -0.9f;
            this.lowerLeftArm.arm.yRot += -0.2f;
            this.lowerLeftArm.arm.zRot += -0.6f;
            this.lowerLeftArm.hand.yRot += -1.7f;
        } else if (renderState.animationTime < 30.0f) {
            float animationProgress = (renderState.animationTime - 24.0f) / 6.0f;
            float rotationAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
            this.rightArm.arm.xRot += -rotationAmount * 0.8f;
            this.rightArm.arm.yRot += rotationAmount * 0.2f;
            this.rightArm.arm.zRot += rotationAmount * 0.8f;
            this.rightArm.hand.yRot += rotationAmount * 1.7f;
            this.leftArm.arm.xRot += -rotationAmount * 0.8f;
            this.leftArm.arm.yRot += -rotationAmount * 0.2f;
            this.leftArm.arm.zRot += -rotationAmount * 0.8f;
            this.leftArm.hand.yRot += -rotationAmount * 1.7f;
            this.lowerRightArm.arm.xRot += -rotationAmount * 0.9f;
            this.lowerRightArm.arm.yRot += rotationAmount * 0.2f;
            this.lowerRightArm.arm.zRot += rotationAmount * 0.6f;
            this.lowerRightArm.hand.yRot += rotationAmount * 1.7f;
            this.lowerLeftArm.arm.xRot += -rotationAmount * 0.9f;
            this.lowerLeftArm.arm.yRot += -rotationAmount * 0.2f;
            this.lowerLeftArm.arm.zRot += -rotationAmount * 0.6f;
            this.lowerLeftArm.hand.yRot += -rotationAmount * 1.7f;
        }
    }

    private void animateDeath(MutantEndermanRenderState renderState) {
        if (renderState.deathTime < 80.0f) {
            float animationProgress = renderState.deathTime / 80.0f;
            float rotationAmount = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
            this.head.xRot += rotationAmount * 0.4f;
            this.neck.xRot += rotationAmount * 0.3f;
            this.pelvis.y += -rotationAmount * 12.0f;
            this.rightArm.arm.xRot += -rotationAmount * 0.4f;
            this.rightArm.arm.yRot += rotationAmount * 0.4f;
            this.rightArm.arm.zRot += rotationAmount * 0.6f;
            this.rightArm.foreArm.xRot += -rotationAmount * 1.2f;
            this.leftArm.arm.xRot += -rotationAmount * 0.4f;
            this.leftArm.arm.yRot += -rotationAmount * 0.2f;
            this.leftArm.arm.zRot += -rotationAmount * 0.6f;
            this.leftArm.foreArm.xRot += -rotationAmount * 1.2f;
            this.lowerRightArm.arm.xRot += -rotationAmount * 0.4f;
            this.lowerRightArm.arm.yRot += rotationAmount * 0.4f;
            this.lowerRightArm.arm.zRot += rotationAmount * 0.6f;
            this.lowerRightArm.foreArm.xRot += -rotationAmount * 1.2f;
            this.lowerLeftArm.arm.xRot += -rotationAmount * 0.4f;
            this.lowerLeftArm.arm.yRot += -rotationAmount * 0.2f;
            this.lowerLeftArm.arm.zRot += -rotationAmount * 0.6f;
            this.lowerLeftArm.foreArm.xRot += -rotationAmount * 1.2f;
            this.leg1.xRot += -rotationAmount * 0.9f;
            this.leg1.yRot += rotationAmount * 0.3f;
            this.leg2.xRot += -rotationAmount * 0.9f;
            this.leg2.yRot += -rotationAmount * 0.3f;
            this.foreLeg1.xRot += rotationAmount * 1.6f;
            this.foreLeg2.xRot += rotationAmount * 1.6f;
        } else if (renderState.deathTime < 84.0f) {
            float animationProgress = (renderState.deathTime - 80.0f) / 4.0f;
            float rotationAmount = Mth.cos((float)(animationProgress * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(animationProgress * (float)Math.PI / 2.0f));
            this.head.xRot += rotationAmount * 0.4f;
            this.mouth.xRot += f1 * 0.6f;
            this.neck.xRot += rotationAmount * 0.4f - 0.1f;
            this.chest.xRot += -f1 * 0.8f;
            this.abdomen.xRot += -f1 * 0.2f;
            this.pelvis.y += -12.0f;
            this.rightArm.arm.xRot += -rotationAmount * 0.4f;
            this.rightArm.arm.yRot += -rotationAmount * 1.4f + 1.8f;
            this.rightArm.arm.zRot += rotationAmount * 0.6f;
            this.rightArm.foreArm.xRot += -rotationAmount * 1.2f;
            this.leftArm.arm.xRot += -rotationAmount * 0.4f;
            this.leftArm.arm.yRot += rotationAmount * 1.6f - 1.8f;
            this.leftArm.arm.zRot += -rotationAmount * 0.6f;
            this.leftArm.foreArm.xRot += -rotationAmount * 1.2f;
            this.lowerRightArm.arm.xRot += -rotationAmount * 0.5f + 0.1f;
            this.lowerRightArm.arm.yRot += -rotationAmount * 1.1f + 1.5f;
            this.lowerRightArm.arm.zRot += rotationAmount * 0.6f;
            this.lowerRightArm.foreArm.xRot += -rotationAmount * 1.2f;
            this.lowerLeftArm.arm.xRot += -rotationAmount * 0.5f + 0.1f;
            this.lowerLeftArm.arm.yRot += rotationAmount * 1.1f - 1.5f;
            this.lowerLeftArm.arm.zRot += -rotationAmount * 0.6f;
            this.lowerLeftArm.foreArm.xRot += -rotationAmount * 1.2f;
            this.leg1.xRot += -rotationAmount * 1.7f + 0.8f;
            this.leg1.yRot += rotationAmount * 0.3f;
            this.leg1.zRot += f1 * 0.2f;
            this.leg2.xRot += -rotationAmount * 1.7f + 0.8f;
            this.leg2.yRot += -rotationAmount * 0.3f;
            this.leg2.zRot += -f1 * 0.2f;
            this.foreLeg1.xRot += rotationAmount * 1.6f;
            this.foreLeg2.xRot += rotationAmount * 1.6f;
        } else {
            this.mouth.xRot += 0.6f;
            this.neck.xRot += -0.1f;
            this.chest.xRot += -0.8f;
            this.abdomen.xRot += -0.2f;
            this.pelvis.y += -12.0f;
            this.rightArm.arm.yRot += 1.0f;
            this.leftArm.arm.yRot += -1.8f;
            this.lowerRightArm.arm.xRot += 0.1f;
            this.lowerRightArm.arm.yRot += 1.0f;
            this.lowerLeftArm.arm.xRot += 0.1f;
            this.lowerLeftArm.arm.yRot += -1.5f;
            this.leg1.xRot += 0.8f;
            this.leg1.zRot += 0.2f;
            this.leg2.xRot += 0.8f;
            this.leg2.zRot += -0.2f;
        }
    }

    private Arm getArmFromId(int id) {
        return id == 0 ? this.rightArm : (id == 1 ? this.leftArm : (id == 2 ? this.lowerRightArm : this.lowerLeftArm));
    }

    public void translateRotateArm(PoseStack poseStack, int id) {
        this.pelvis.translateAndRotate(poseStack);
        this.abdomen.translateAndRotate(poseStack);
        this.chest.translateAndRotate(poseStack);
        this.getArmFromId(id).translateRotate(poseStack);
    }

    static class Arm {
        private final ModelPart arm;
        private final ModelPart foreArm;
        private final ModelPart hand;
        private final ModelPart[] finger = new ModelPart[3];
        private final ModelPart[] foreFinger = new ModelPart[3];
        private final ModelPart thumb;
        private final boolean right;

        private Arm(String prefix, ModelPart modelPart, boolean right) {
            this.right = right;
            this.arm = modelPart.getChild(prefix + "arm");
            this.foreArm = this.arm.getChild(prefix + "fore_arm");
            this.hand = this.foreArm.getChild(prefix + "hand");
            for (int i = 0; i < 3; ++i) {
                this.finger[i] = this.hand.getChild(prefix + "finger" + i);
                this.foreFinger[i] = this.finger[i].getChild(prefix + "fore_finger" + i);
            }
            this.thumb = this.hand.getChild(prefix + "thumb");
        }

        static void createArmLayer(String prefix, PartDefinition root, boolean right, boolean lower) {
            PartDefinition arm = root.addOrReplaceChild(prefix + "arm", CubeListBuilder.create().texOffs(92, 0).addBox(-1.5f, lower ? 6.0f : 0.0f, -1.5f, 3.0f, 22.0f, 3.0f, new CubeDeformation(0.1f)).mirror(!right), PartPose.offset((float)(right ? -4.0f : 4.0f), (float)-14.0f, (float)0.0f));
            PartDefinition foreArm = arm.addOrReplaceChild(prefix + "fore_arm", CubeListBuilder.create().texOffs(104, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 18.0f, 3.0f).mirror(!right), PartPose.offset((float)0.0f, (float)21.0f, (float)1.0f));
            PartDefinition hand = foreArm.addOrReplaceChild(prefix + "hand", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)17.5f, (float)0.0f));
            for (int i = 0; i < 3; ++i) {
                PartPose partPose = i == 0 ? PartPose.offset((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)-1.0f) : (i == 1 ? PartPose.offset((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)0.0f) : PartPose.offset((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)1.0f));
                PartDefinition finger = hand.addOrReplaceChild(prefix + "finger" + i, CubeListBuilder.create().texOffs(76, 0).mirror(!right).addBox(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new CubeDeformation(0.6f)), partPose);
                finger.addOrReplaceChild(prefix + "fore_finger" + i, CubeListBuilder.create().texOffs(76, 0).mirror(!right).addBox(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new CubeDeformation(0.59000003f)), PartPose.offset((float)0.0f, (float)(0.5f + (float)(i == 1 ? 6 : 5)), (float)0.0f));
            }
            hand.addOrReplaceChild(prefix + "thumb", CubeListBuilder.create().texOffs(76, 0).mirror(right).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.6f)), PartPose.offset((float)(right ? 0.5f : -0.5f), (float)0.0f, (float)-0.5f));
        }

        private void setAngles() {
            Animator.resetAngles(this.arm);
            Animator.resetAngles(this.foreArm);
            Animator.resetAngles(this.hand);
            for (int i = 0; i < this.finger.length; ++i) {
                Animator.resetAngles(this.finger[i]);
                Animator.resetAngles(this.foreFinger[i]);
            }
            Animator.resetAngles(this.thumb);
            if (this.right) {
                this.arm.xRot = -0.5235988f;
                this.arm.zRot = 0.5235988f;
                this.foreArm.xRot = -0.62831855f;
                this.hand.yRot = -0.3926991f;
                this.finger[0].xRot = -0.2617994f;
                this.finger[1].zRot = 0.17453294f;
                this.finger[2].xRot = 0.2617994f;
                this.foreFinger[0].zRot = -0.2617994f;
                this.foreFinger[1].zRot = -0.3926991f;
                this.foreFinger[2].zRot = -0.2617994f;
                this.thumb.xRot = -0.62831855f;
                this.thumb.zRot = -0.3926991f;
            } else {
                this.arm.xRot = -0.5235988f;
                this.arm.zRot = -0.5235988f;
                this.foreArm.xRot = -0.62831855f;
                this.hand.yRot = 0.3926991f;
                this.finger[0].xRot = -0.2617994f;
                this.finger[1].zRot = -0.17453294f;
                this.finger[2].xRot = 0.2617994f;
                this.foreFinger[0].zRot = 0.2617994f;
                this.foreFinger[1].zRot = 0.3926991f;
                this.foreFinger[2].zRot = 0.2617994f;
                this.thumb.xRot = -0.62831855f;
                this.thumb.zRot = 0.3926991f;
            }
        }

        private void translateRotate(PoseStack matrixStackIn) {
            this.arm.translateAndRotate(matrixStackIn);
            this.foreArm.translateAndRotate(matrixStackIn);
            this.hand.translateAndRotate(matrixStackIn);
        }
    }
}

