/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fuzs.mutantmonsters.client.model.MutantSkeletonModel;
import fuzs.mutantmonsters.world.entity.MutantSkeletonBodyPart;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class MutantSkeletonPartModel
extends Model {
    private final Map<MutantSkeletonBodyPart.BodyPart, ModelPart> bodyParts;

    public MutantSkeletonPartModel(ModelPart modelPart, ModelPart spineModelPart) {
        super(modelPart, RenderType::entityCutoutNoCull);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.PELVIS, (Object)modelPart.getChild("pelvis"));
        MutantSkeletonModel.Spine spine = new MutantSkeletonModel.Spine(spineModelPart);
        spine.setAngles(false);
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.LEFT_UPPER_RIB, (Object)spine.side1[0]);
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.RIGHT_UPPER_RIB, (Object)spine.side2[0]);
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.LEFT_MIDDLE_RIB, (Object)spine.side1[0]);
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.RIGHT_MIDDLE_RIB, (Object)spine.side2[0]);
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.LEFT_LOWER_RIB, (Object)spine.side1[0]);
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.RIGHT_LOWER_RIB, (Object)spine.side2[0]);
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.HEAD, (Object)modelPart.getChild("head"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.LEFT_ARM, (Object)modelPart.getChild("arm1"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.RIGHT_ARM, (Object)modelPart.getChild("arm2"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.LEFT_FORE_ARM, (Object)modelPart.getChild("forearm1"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.RIGHT_FORE_ARM, (Object)modelPart.getChild("forearm2"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.LEFT_LEG, (Object)modelPart.getChild("leg1"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.RIGHT_LEG, (Object)modelPart.getChild("leg2"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.LEFT_FORE_LEG, (Object)modelPart.getChild("foreleg1"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.RIGHT_FORE_LEG, (Object)modelPart.getChild("foreleg2"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.LEFT_SHOULDER, (Object)modelPart.getChild("shoulder1"));
        builder.put((Object)MutantSkeletonBodyPart.BodyPart.RIGHT_SHOULDER, (Object)modelPart.getChild("shoulder2"));
        this.bodyParts = Maps.immutableEnumMap((Map)builder.build());
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("pelvis", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 6.0f), PartPose.ZERO);
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.4f)), PartPose.ZERO);
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(72, 0).addBox(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.7f)), PartPose.offsetAndRotation((float)0.0f, (float)3.8f, (float)3.7f, (float)0.09817477f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(0, 28).mirror().addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("forearm1", CubeListBuilder.create().texOffs(16, 28).addBox(-2.0f, -7.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.ZERO);
        root.addOrReplaceChild("forearm2", CubeListBuilder.create().texOffs(16, 28).mirror().addBox(-2.0f, -7.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.ZERO);
        root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 28).mirror().addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("foreleg1", CubeListBuilder.create().texOffs(32, 28).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("foreleg2", CubeListBuilder.create().texOffs(32, 28).mirror().addBox(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("shoulder1", CubeListBuilder.create().texOffs(28, 16).addBox(-4.0f, -1.5f, -3.0f, 8.0f, 3.0f, 6.0f), PartPose.ZERO);
        root.addOrReplaceChild("shoulder2", CubeListBuilder.create().texOffs(28, 16).mirror().addBox(-4.0f, -1.5f, -3.0f, 8.0f, 3.0f, 6.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public ModelPart getBodyPart(MutantSkeletonBodyPart.BodyPart bodyPart) {
        return this.bodyParts.get((Object)bodyPart);
    }
}

