/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantZombieRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;

public class MutantZombieModel
extends EntityModel<MutantZombieRenderState> {
    private final ModelPart pelvis;
    private final ModelPart waist;
    private final ModelPart chest;
    private final ModelPart head;
    private final ModelPart arm1;
    private final ModelPart arm2;
    private final ModelPart forearm1;
    private final ModelPart forearm2;
    private final ModelPart leg1;
    private final ModelPart leg2;

    public MutantZombieModel(ModelPart modelPart) {
        super(modelPart);
        this.pelvis = modelPart.getChild("pelvis");
        this.waist = this.pelvis.getChild("waist");
        this.chest = this.waist.getChild("chest");
        this.head = this.chest.getChild("head");
        this.arm1 = this.chest.getChild("arm1");
        this.arm2 = this.chest.getChild("arm2");
        this.forearm1 = this.arm1.getChild("fore_arm1");
        this.forearm2 = this.arm2.getChild("fore_arm2");
        this.leg1 = this.pelvis.getChild("leg1");
        this.leg2 = this.pelvis.getChild("leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partDefinition = mesh.getRoot();
        PartDefinition pelvis = partDefinition.addOrReplaceChild("pelvis", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)10.0f, (float)6.0f));
        PartDefinition waist = pelvis.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(0, 44).addBox(-7.0f, -16.0f, -6.0f, 14.0f, 16.0f, 12.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.19634955f, (float)0.0f, (float)0.0f));
        PartDefinition chest = waist.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 16).addBox(-12.0f, -12.0f, -8.0f, 24.0f, 12.0f, 16.0f), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        chest.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)-4.0f, (float)-0.71994835f, (float)0.0f, (float)0.0f));
        PartDefinition arm1 = chest.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(104, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f), PartPose.offsetAndRotation((float)-11.0f, (float)-8.0f, (float)2.0f, (float)-0.32724923f, (float)0.0f, (float)0.3926991f));
        PartDefinition arm2 = chest.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(104, 0).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f), PartPose.offsetAndRotation((float)11.0f, (float)-8.0f, (float)2.0f, (float)-0.32724923f, (float)0.0f, (float)-0.3926991f));
        arm1.addOrReplaceChild("fore_arm1", CubeListBuilder.create().texOffs(104, 22).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)0.0f, (float)-1.0471976f, (float)0.0f, (float)0.0f));
        arm2.addOrReplaceChild("fore_arm2", CubeListBuilder.create().texOffs(104, 22).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)0.0f, (float)-1.0471976f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = pelvis.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(80, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 11.0f, 6.0f), PartPose.offsetAndRotation((float)-5.0f, (float)-2.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition leg2 = pelvis.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(80, 0).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 11.0f, 6.0f), PartPose.offsetAndRotation((float)5.0f, (float)-2.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        leg1.addOrReplaceChild("fore_leg1", CubeListBuilder.create().texOffs(80, 17).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)9.5f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        leg2.addOrReplaceChild("fore_leg2", CubeListBuilder.create().texOffs(80, 17).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)9.5f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void setupAnim(MutantZombieRenderState renderState) {
        super.setupAnim((EntityRenderState)renderState);
        float walkAnim1 = (Mth.sin((float)((renderState.walkAnimationPos - 0.7f) * 0.4f)) + 0.7f) * renderState.walkAnimationSpeed;
        float walkAnim2 = -(Mth.sin((float)((renderState.walkAnimationPos + 0.7f) * 0.4f)) - 0.7f) * renderState.walkAnimationSpeed;
        float walkAnim = Mth.sin((float)(renderState.walkAnimationPos * 0.4f)) * renderState.walkAnimationSpeed;
        float breatheAnim = Mth.sin((float)(renderState.ageInTicks * 0.1f));
        float faceYaw = renderState.yRot * (float)Math.PI / 180.0f;
        float facePitch = renderState.xRot * (float)Math.PI / 180.0f;
        if (renderState.deathTime <= 0.0f) {
            float scale;
            if (renderState.animation == MutantZombie.SLAM_GROUND_ANIMATION) {
                this.animateMelee(renderState);
            }
            if (renderState.animation == MutantZombie.ROAR_ANIMATION) {
                this.animateRoar(renderState);
                scale = 1.0f - Mth.clamp((float)(renderState.animationTime / 6.0f), (float)0.0f, (float)1.0f);
                walkAnim1 *= scale;
                walkAnim2 *= scale;
                walkAnim *= scale;
                facePitch *= scale;
            }
            if (renderState.animation == MutantZombie.THROW_ANIMATION) {
                this.animateThrow(renderState);
                scale = 1.0f - Mth.clamp((float)(renderState.animationTime / 3.0f), (float)0.0f, (float)1.0f);
                walkAnim1 *= scale;
                walkAnim2 *= scale;
                walkAnim *= scale;
                facePitch *= scale;
            }
        } else {
            this.animateDeath(renderState);
            float scale = 1.0f - Mth.clamp((float)(renderState.deathTime / 6.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim *= scale;
            breatheAnim *= scale;
            faceYaw *= scale;
            facePitch *= scale;
        }
        this.chest.xRot += breatheAnim * 0.02f;
        this.arm1.zRot -= breatheAnim * 0.05f;
        this.arm2.zRot += breatheAnim * 0.05f;
        this.head.xRot += facePitch * 0.6f;
        this.head.yRot += faceYaw * 0.8f;
        this.head.zRot -= faceYaw * 0.2f;
        this.chest.xRot += facePitch * 0.4f;
        this.chest.yRot += faceYaw * 0.2f;
        this.pelvis.y += Mth.sin((float)(renderState.walkAnimationPos * 0.8f)) * renderState.walkAnimationSpeed * 0.5f;
        this.chest.yRot -= walkAnim * 0.1f;
        this.arm1.xRot -= walkAnim * 0.6f;
        this.arm2.xRot += walkAnim * 0.6f;
        this.leg1.xRot += walkAnim1 * 0.9f;
        this.leg2.xRot += walkAnim2 * 0.9f;
    }

    private void animateMelee(MutantZombieRenderState renderState) {
        this.arm1.zRot = 0.0f;
        this.arm2.zRot = 0.0f;
        if (renderState.animationTime < 8.0f) {
            float tick = renderState.animationTime / 8.0f;
            float f = -Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.2f;
            this.chest.xRot += f * 0.2f;
            this.arm1.xRot += f * 2.3f;
            this.arm1.zRot += f1 * (float)Math.PI / 8.0f;
            this.arm2.xRot += f * 2.3f;
            this.arm2.zRot -= f1 * (float)Math.PI / 8.0f;
            this.forearm1.xRot += f * 0.8f;
            this.forearm2.xRot += f * 0.8f;
        } else if (renderState.animationTime < 12.0f) {
            float tick = (renderState.animationTime - 8.0f) / 4.0f;
            float f = -Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.9f + 0.7f;
            this.chest.xRot += f * 0.9f + 0.7f;
            this.arm1.xRot += f * 0.2f - 2.1f;
            this.arm1.zRot += f1 * 0.3f;
            this.arm2.xRot += f * 0.2f - 2.1f;
            this.arm2.zRot -= f1 * 0.3f;
            this.forearm1.xRot += f + 0.2f;
            this.forearm2.xRot += f + 0.2f;
        } else if (renderState.animationTime < 16.0f) {
            this.waist.xRot += 0.7f;
            this.chest.xRot += 0.7f;
            this.arm1.xRot -= 2.1f;
            this.arm1.zRot += 0.3f;
            this.arm2.xRot -= 2.1f;
            this.arm2.zRot -= 0.3f;
            this.forearm1.xRot += 0.2f;
            this.forearm2.xRot += 0.2f;
        } else if (renderState.animationTime < 24.0f) {
            float tick = (renderState.animationTime - 16.0f) / 8.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.7f;
            this.chest.xRot += f * 0.7f;
            this.arm1.xRot -= f * 2.1f;
            this.arm1.zRot += f * -0.09269908f + 0.3926991f;
            this.arm2.xRot -= f * 2.1f;
            this.arm2.zRot -= f * -0.09269908f + 0.3926991f;
            this.forearm1.xRot += f * 0.2f;
            this.forearm2.xRot += f * 0.2f;
        } else {
            this.arm1.zRot += 0.3926991f;
            this.arm2.zRot += -0.3926991f;
        }
    }

    private void animateRoar(MutantZombieRenderState renderState) {
        float f1;
        float f;
        float tick;
        if (renderState.animationTime < 10.0f) {
            tick = renderState.animationTime / 10.0f;
            f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            f1 = Mth.sin((float)(tick * (float)Math.PI * (float)Math.PI / 8.0f));
            this.waist.xRot += f * 0.2f;
            this.chest.xRot += f * 0.4f;
            this.chest.yRot += f1 * 0.06f;
            this.head.xRot += f * 0.8f;
            this.arm1.xRot -= f * 1.2f;
            this.arm1.zRot += f * 0.6f;
            this.arm2.xRot -= f * 1.2f;
            this.arm2.zRot -= f * 0.6f;
            this.forearm1.xRot -= f * 0.8f;
            this.forearm2.xRot -= f * 0.8f;
        } else if (renderState.animationTime < 15.0f) {
            tick = (renderState.animationTime - 10.0f) / 5.0f;
            f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.39634955f - 0.19634955f;
            this.chest.xRot += f * 0.6f - 0.2f;
            this.head.xRot += f - 0.2f;
            this.arm1.xRot -= f * 2.2f - 1.0f;
            this.arm1.yRot += f1 * 0.4f;
            this.arm1.zRot += 0.6f;
            this.arm2.xRot -= f * 2.2f - 1.0f;
            this.arm2.yRot -= f1 * 0.4f;
            this.arm2.zRot -= 0.6f;
            this.forearm1.xRot -= f - 0.2f;
            this.forearm2.xRot -= f - 0.2f;
            this.leg1.yRot += f1 * 0.3f;
            this.leg2.yRot -= f1 * 0.3f;
        } else if (renderState.animationTime < 75.0f) {
            this.waist.xRot -= 0.19634955f;
            this.chest.xRot -= 0.2f;
            this.head.xRot -= 0.2f;
            Animator.addRotationAngle(this.arm1, 1.0f, 0.4f, 0.6f);
            Animator.addRotationAngle(this.arm2, 1.0f, -0.4f, -0.6f);
            this.forearm1.xRot += 0.2f;
            this.forearm2.xRot += 0.2f;
            this.leg1.yRot += 0.3f;
            this.leg2.yRot -= 0.3f;
        } else if (renderState.animationTime < 90.0f) {
            tick = (renderState.animationTime - 75.0f) / 15.0f;
            f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot -= f * 0.69634956f - 0.5f;
            this.chest.xRot -= f * 0.7f - 0.5f;
            this.head.xRot -= f * 0.6f - 0.4f;
            Animator.addRotationAngle(this.arm1, f * 2.6f - 1.6f, f * 0.4f, f * 0.99269915f - 0.3926991f);
            Animator.addRotationAngle(this.arm2, f * 2.6f - 1.6f, -f * 0.4f, -f * 0.99269915f + 0.3926991f);
            this.forearm1.xRot += f * -0.6f + 0.8f;
            this.forearm2.xRot += f * -0.6f + 0.8f;
            this.leg1.yRot += f * 0.3f;
            this.leg2.yRot -= f * 0.3f;
        } else if (renderState.animationTime < 110.0f) {
            this.waist.xRot += 0.5f;
            this.chest.xRot += 0.5f;
            this.head.xRot += 0.4f;
            Animator.addRotationAngle(this.arm1, -1.6f, 0.0f, -0.3926991f);
            Animator.addRotationAngle(this.arm2, -1.6f, 0.0f, 0.3926991f);
            this.forearm1.xRot += 0.8f;
            this.forearm2.xRot += 0.8f;
        } else {
            tick = (renderState.animationTime - 110.0f) / 10.0f;
            f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.5f;
            this.chest.xRot += f * 0.5f;
            this.head.xRot += f * 0.4f;
            Animator.addRotationAngle(this.arm1, f * -1.6f, 0.0f, f * (float)(-Math.PI) / 8.0f);
            Animator.addRotationAngle(this.arm2, f * -1.6f, 0.0f, f * (float)Math.PI / 8.0f);
            this.forearm1.xRot += f * 0.8f;
            this.forearm2.xRot += f * 0.8f;
        }
        if (renderState.animationTime >= 10.0f && renderState.animationTime < 75.0f) {
            tick = (renderState.animationTime - 10.0f) / 65.0f;
            f = Mth.sin((float)(tick * (float)Math.PI * 8.0f));
            f1 = Mth.sin((float)(tick * (float)Math.PI * 8.0f + 0.7853982f));
            this.head.yRot += f * 0.5f - f1 * 0.2f;
            this.head.zRot -= f * 0.5f;
            this.chest.yRot += f1 * 0.06f;
        }
    }

    private void animateThrow(MutantZombieRenderState renderState) {
        if (renderState.animationTime < 3.0f) {
            float tick = renderState.animationTime / 3.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.chest.xRot -= f * 0.4f;
            this.arm1.xRot -= f * 1.8f;
            this.arm1.zRot -= f * (float)Math.PI / 8.0f;
            this.arm2.xRot -= f * 1.8f;
            this.arm2.zRot += f * (float)Math.PI / 8.0f;
        } else if (renderState.animationTime < 5.0f) {
            this.chest.xRot -= 0.4f;
            this.arm1.xRot -= 1.0f;
            this.arm1.zRot = 0.0f;
            this.arm2.xRot -= 1.0f;
            this.arm2.zRot = 0.0f;
        } else if (renderState.animationTime < 8.0f) {
            float tick = (renderState.animationTime - 5.0f) / 3.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f1 * 0.2f;
            this.chest.xRot -= f * 0.6f - 0.2f;
            this.arm1.xRot -= f * 2.2f - 0.4f;
            this.arm1.zRot -= f * (float)Math.PI / 8.0f;
            this.arm2.xRot -= f * 2.2f - 0.4f;
            this.arm2.zRot += f * (float)Math.PI / 8.0f;
            this.forearm1.xRot -= f1 * 0.4f;
            this.forearm2.xRot -= f1 * 0.4f;
        } else if (renderState.animationTime < 10.0f) {
            this.waist.xRot += 0.2f;
            this.chest.xRot += 0.2f;
            this.arm1.xRot += 0.4f;
            this.arm2.xRot += 0.4f;
            this.forearm1.xRot -= 0.4f;
            this.forearm2.xRot -= 0.4f;
        } else if (renderState.animationTime < 15.0f) {
            float tick = (renderState.animationTime - 10.0f) / 5.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.39634955f - 0.19634955f;
            this.chest.xRot += f * 0.8f - 0.6f;
            this.arm1.xRot += f * 3.0f - 2.6f;
            this.arm2.xRot += f * 3.0f - 2.6f;
            this.forearm1.xRot -= f * 0.4f;
            this.forearm2.xRot -= f * 0.4f;
            this.leg1.xRot += f1 * 0.6f;
            this.leg2.xRot += f1 * 0.6f;
        } else if (renderState.throwHitTime == -1.0f) {
            this.waist.xRot -= 0.19634955f;
            this.chest.xRot -= 0.6f;
            this.arm1.xRot -= 2.6f;
            this.arm2.xRot -= 2.6f;
            this.leg1.xRot += 0.6f;
            this.leg2.xRot += 0.6f;
        } else if (renderState.throwHitTime < 5.0f) {
            float tick = renderState.throwHitTime / 3.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot -= f * 0.39634955f - 0.2f;
            this.chest.xRot -= f * 0.8f - 0.2f;
            Animator.addRotationAngle(this.arm1, -(f * 2.2f + 0.4f), -f1 * (float)Math.PI / 8.0f, f1 * 0.4f);
            Animator.addRotationAngle(this.arm2, -(f * 2.2f + 0.4f), f1 * (float)Math.PI / 8.0f, -f1 * 0.4f);
            this.forearm1.xRot += f1 * 0.2f;
            this.forearm2.xRot += f1 * 0.2f;
            this.leg1.xRot += f * 0.8f - 0.2f;
            this.leg2.xRot += f * 0.8f - 0.2f;
        } else if (renderState.throwFinishTime == -1.0f) {
            this.waist.xRot += 0.2f;
            this.chest.xRot += 0.2f;
            Animator.addRotationAngle(this.arm1, -0.4f, -0.3926991f, 0.4f);
            Animator.addRotationAngle(this.arm2, -0.4f, 0.3926991f, -0.4f);
            this.forearm1.xRot += 0.2f;
            this.forearm2.xRot += 0.2f;
            this.leg1.xRot -= 0.2f;
            this.leg2.xRot -= 0.2f;
        } else if (renderState.throwFinishTime < 10.0f) {
            float tick = renderState.throwFinishTime / 10.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.waist.xRot += f * 0.2f;
            this.chest.xRot += f * 0.2f;
            Animator.addRotationAngle(this.arm1, -f * 0.4f, -f * (float)Math.PI / 8.0f, f * 0.4f);
            Animator.addRotationAngle(this.arm1, -f * 0.4f, f * (float)Math.PI / 8.0f, -f * 0.4f);
            this.forearm1.xRot += f * 0.2f;
            this.forearm2.xRot += f * 0.2f;
            this.leg1.xRot -= f * 0.2f;
            this.leg2.xRot -= f * 0.2f;
        }
    }

    private void animateDeath(MutantZombieRenderState renderState) {
        if (renderState.deathTime <= 20.0f) {
            float tick = (renderState.deathTime - 1.0f) / 20.0f;
            float f = Mth.sin((float)(tick * (float)Math.PI / 2.0f));
            this.pelvis.y += f * 28.0f;
            this.head.xRot -= f * (float)Math.PI / 10.0f;
            this.head.yRot += f * (float)Math.PI / 5.0f;
            this.chest.xRot -= f * (float)Math.PI / 12.0f;
            this.waist.xRot -= f * (float)Math.PI / 10.0f;
            this.arm1.xRot -= f * (float)Math.PI / 2.0f;
            this.arm1.yRot += f * (float)Math.PI / 2.8f;
            this.arm2.xRot -= f * (float)Math.PI / 2.0f;
            this.arm2.yRot -= f * (float)Math.PI / 2.8f;
            this.leg1.xRot += f * (float)Math.PI / 6.0f;
            this.leg1.zRot += f * (float)Math.PI / 12.0f;
            this.leg2.xRot += f * (float)Math.PI / 6.0f;
            this.leg2.zRot -= f * (float)Math.PI / 12.0f;
        } else if (renderState.deathTime <= 100.0f) {
            this.pelvis.y += 28.0f;
            this.head.xRot -= 0.31415927f;
            this.head.yRot += 0.62831855f;
            this.chest.xRot -= 0.2617994f;
            this.waist.xRot -= 0.31415927f;
            this.arm1.xRot -= 1.0f;
            this.arm1.yRot += 1.0f;
            this.arm2.xRot -= 1.0f;
            this.arm2.yRot -= 1.0f;
            this.leg1.xRot += 0.5235988f;
            this.leg1.zRot += 0.2617994f;
            this.leg2.xRot += 0.5235988f;
            this.leg2.zRot -= 0.2617994f;
        } else {
            float tick = (40.0f - (140.0f - renderState.deathTime)) / 40.0f;
            float f = Mth.cos((float)(tick * (float)Math.PI / 2.0f));
            this.pelvis.y += f * 28.0f;
            this.head.xRot -= f * (float)Math.PI / 10.0f;
            this.head.yRot += f * (float)Math.PI / 5.0f;
            this.chest.xRot -= f * (float)Math.PI / 12.0f;
            this.waist.xRot -= f * (float)Math.PI / 10.0f;
            this.arm1.xRot -= f * (float)Math.PI / 2.0f;
            this.arm1.yRot += f * (float)Math.PI / 2.8f;
            this.arm2.xRot -= f * (float)Math.PI / 2.0f;
            this.arm2.yRot -= f * (float)Math.PI / 2.8f;
            this.leg1.xRot += f * (float)Math.PI / 6.0f;
            this.leg1.zRot += f * (float)Math.PI / 12.0f;
            this.leg2.xRot += f * (float)Math.PI / 6.0f;
            this.leg2.zRot -= f * (float)Math.PI / 12.0f;
        }
    }
}

