/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import fuzs.mutantmonsters.client.renderer.entity.state.SpiderPigRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;

public class SpiderPigModel
extends EntityModel<SpiderPigRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling((float)0.5f);
    private final ModelPart head;
    private final ModelPart innerHead;
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart butt;
    private final ModelPart frontLeg1;
    private final ModelPart innerFrontLeg1;
    private final ModelPart lowerFrontLeg1;
    private final ModelPart frontLeg2;
    private final ModelPart innerFrontLeg2;
    private final ModelPart lowerFrontLeg2;
    private final ModelPart middleLeg1;
    private final ModelPart innerMiddleLeg1;
    private final ModelPart lowerMiddleLeg1;
    private final ModelPart middleLeg2;
    private final ModelPart innerMiddleLeg2;
    private final ModelPart lowerMiddleLeg2;
    private final ModelPart backLeg1;
    private final ModelPart backLeg2;

    public SpiderPigModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart base = modelPart.getChild("base");
        this.body2 = base.getChild("body2");
        this.body1 = this.body2.getChild("body1");
        this.butt = this.body2.getChild("butt");
        this.head = this.body1.getChild("head");
        this.innerHead = this.head.getChild("inner_head");
        this.frontLeg1 = this.body1.getChild("front_leg1");
        this.innerFrontLeg1 = this.frontLeg1.getChild("inner_front_leg1");
        this.lowerFrontLeg1 = this.innerFrontLeg1.getChild("lower_front_leg1");
        this.lowerFrontLeg1.getChild("inner_lower_front_leg1");
        this.frontLeg2 = this.body1.getChild("front_leg2");
        this.innerFrontLeg2 = this.frontLeg2.getChild("inner_front_leg2");
        this.lowerFrontLeg2 = this.innerFrontLeg2.getChild("lower_front_leg2");
        this.lowerFrontLeg2.getChild("inner_lower_front_leg2");
        this.middleLeg1 = this.body1.getChild("middle_leg1");
        this.innerMiddleLeg1 = this.middleLeg1.getChild("inner_middle_leg1");
        this.lowerMiddleLeg1 = this.innerMiddleLeg1.getChild("lower_middle_leg1");
        this.lowerMiddleLeg1.getChild("inner_lower_middle_leg1");
        this.middleLeg2 = this.body1.getChild("middle_leg2");
        this.innerMiddleLeg2 = this.middleLeg2.getChild("inner_middle_leg2");
        this.lowerMiddleLeg2 = this.innerMiddleLeg2.getChild("lower_middle_leg2");
        this.lowerMiddleLeg2.getChild("inner_lower_middle_leg2");
        this.backLeg1 = this.body2.getChild("back_leg1");
        this.backLeg2 = this.body2.getChild("back_leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition base = root.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)14.5f, (float)-2.0f));
        PartDefinition body2 = base.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(32, 0).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 6.0f, 10.0f).texOffs(44, 16).addBox(-5.0f, -5.0f, -4.0f, 10.0f, 8.0f, 12.0f, new CubeDeformation(-0.6f)), PartPose.ZERO);
        PartDefinition body1 = body2.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(64, 0), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.5f));
        body1.addOrReplaceChild("inner_body1", CubeListBuilder.create().texOffs(64, 0).addBox(-3.5f, -3.5f, -9.0f, 7.0f, 7.0f, 9.0f), PartPose.ZERO);
        body2.addOrReplaceChild("butt", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, -4.5f, 0.0f, 10.0f, 9.0f, 12.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)7.0f));
        PartDefinition head = body1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)0.0f, (float)-8.0f));
        PartDefinition innerHead = head.addOrReplaceChild("inner_head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        innerHead.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(24, 0).addBox(-2.0f, 0.0f, -9.0f, 4.0f, 3.0f, 1.0f), PartPose.ZERO);
        PartDefinition frontLeg1 = body1.addOrReplaceChild("front_leg1", CubeListBuilder.create().texOffs(0, 37), PartPose.offset((float)-3.5f, (float)0.0f, (float)-5.0f));
        PartDefinition innerFrontLeg1 = frontLeg1.addOrReplaceChild("inner_front_leg1", CubeListBuilder.create().texOffs(0, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.ZERO);
        PartDefinition lowerFrontLeg1 = innerFrontLeg1.addOrReplaceChild("lower_front_leg1", CubeListBuilder.create().texOffs(8, 37), PartPose.offset((float)-0.0f, (float)12.0f, (float)-0.1f));
        lowerFrontLeg1.addOrReplaceChild("inner_lower_front_leg1", CubeListBuilder.create().texOffs(8, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 16.0f, 2.0f), PartPose.ZERO);
        PartDefinition frontLeg2 = body1.addOrReplaceChild("front_leg2", CubeListBuilder.create().texOffs(0, 37).mirror(), PartPose.offset((float)3.5f, (float)0.0f, (float)-5.0f));
        PartDefinition innerFrontLeg2 = frontLeg2.addOrReplaceChild("inner_front_leg2", CubeListBuilder.create().texOffs(0, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.ZERO);
        PartDefinition lowerFrontLeg2 = innerFrontLeg2.addOrReplaceChild("lower_front_leg2", CubeListBuilder.create().texOffs(8, 37).mirror(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.1f));
        lowerFrontLeg2.addOrReplaceChild("inner_lower_front_leg2", CubeListBuilder.create().texOffs(8, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 16.0f, 2.0f), PartPose.ZERO);
        PartDefinition middleLeg1 = body1.addOrReplaceChild("middle_leg1", CubeListBuilder.create().texOffs(0, 37), PartPose.offset((float)-3.5f, (float)0.0f, (float)-3.0f));
        PartDefinition innerMiddleLeg1 = middleLeg1.addOrReplaceChild("inner_middle_leg1", CubeListBuilder.create().texOffs(0, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.ZERO);
        PartDefinition lowerMiddleLeg1 = innerMiddleLeg1.addOrReplaceChild("lower_middle_leg1", CubeListBuilder.create().texOffs(8, 37), PartPose.offset((float)0.0f, (float)12.0f, (float)-0.1f));
        lowerMiddleLeg1.addOrReplaceChild("inner_lower_middle_leg1", CubeListBuilder.create().texOffs(8, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 16.0f, 2.0f), PartPose.ZERO);
        PartDefinition middleLeg2 = body1.addOrReplaceChild("middle_leg2", CubeListBuilder.create().texOffs(0, 37).mirror(), PartPose.offset((float)3.5f, (float)0.0f, (float)-3.0f));
        PartDefinition innerMiddleLeg2 = middleLeg2.addOrReplaceChild("inner_middle_leg2", CubeListBuilder.create().texOffs(0, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.ZERO);
        PartDefinition lowerMiddleLeg2 = innerMiddleLeg2.addOrReplaceChild("lower_middle_leg2", CubeListBuilder.create().texOffs(8, 37).mirror(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.1f));
        lowerMiddleLeg2.addOrReplaceChild("inner_lower_middle_leg2", CubeListBuilder.create().texOffs(8, 37).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 16.0f, 2.0f), PartPose.ZERO);
        PartDefinition backLeg1 = body2.addOrReplaceChild("back_leg1", CubeListBuilder.create().texOffs(16, 37).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)-2.5f, (float)2.0f, (float)7.0f, (float)-0.3926991f, (float)0.0f, (float)0.3926991f));
        backLeg1.addOrReplaceChild("lower_back_leg1", CubeListBuilder.create().texOffs(16, 45).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.5711987f, (float)0.0f, (float)-0.3926991f));
        PartDefinition backLeg2 = body2.addOrReplaceChild("back_leg2", CubeListBuilder.create().texOffs(32, 37).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)2.5f, (float)2.0f, (float)7.0f, (float)-0.3926991f, (float)0.0f, (float)-0.3926991f));
        backLeg2.addOrReplaceChild("lower_back_leg2", CubeListBuilder.create().texOffs(16, 45).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.5711987f, (float)0.0f, (float)0.3926991f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void setupAnim(SpiderPigRenderState renderState) {
        super.setupAnim((EntityRenderState)renderState);
        this.setupInitialAngles();
        float limbSwing = renderState.walkAnimationPos;
        float limbSwingAmount = renderState.walkAnimationSpeed;
        float ageInTicks = renderState.ageInTicks;
        float netHeadYaw = renderState.yRot;
        float headPitch = renderState.xRot;
        this.animate(renderState, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setupInitialAngles() {
        this.body1.xRot = 0.3926991f;
        this.body2.xRot = -0.05235988f;
        this.butt.xRot = 0.5711987f;
        this.head.xRot = -0.3926991f;
        this.frontLeg1.xRot = -0.3403392f;
        this.frontLeg1.yRot = -1.0471976f;
        this.innerFrontLeg1.zRot = 2.0943952f;
        this.lowerFrontLeg1.zRot = -1.6534699f;
        this.frontLeg2.xRot = -0.3403392f;
        this.frontLeg2.yRot = 1.0471976f;
        this.innerFrontLeg2.zRot = -2.0943952f;
        this.lowerFrontLeg2.zRot = 1.6534699f;
        this.middleLeg1.xRot = -0.3403392f;
        this.middleLeg1.yRot = -0.31415927f;
        this.innerMiddleLeg1.zRot = 2.0399954f;
        this.lowerMiddleLeg1.zRot = -1.6534699f;
        this.middleLeg2.xRot = -0.3403392f;
        this.middleLeg2.yRot = 0.31415927f;
        this.innerMiddleLeg2.zRot = -2.0399954f;
        this.lowerMiddleLeg2.zRot = 1.6534699f;
    }

    private void animate(SpiderPigRenderState renderState, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float moveAnim = Mth.sin((float)(limbSwing * 0.9f)) * limbSwingAmount;
        float moveAnim1 = Mth.sin((float)(limbSwing * 0.9f + 0.3f)) * limbSwingAmount;
        float moveAnim1d = Mth.sin((float)(limbSwing * 0.9f + 0.3f + 0.5f)) * limbSwingAmount;
        float moveAnim2 = Mth.sin((float)(limbSwing * 0.9f + 0.9f)) * limbSwingAmount;
        float moveAnim2d = Mth.sin((float)(limbSwing * 0.9f + 0.9f + 0.5f)) * limbSwingAmount;
        float moveAnim3 = Mth.sin((float)(limbSwing * 0.9f - 0.3f)) * limbSwingAmount;
        float moveAnim3d = Mth.sin((float)(limbSwing * 0.9f - 0.3f + 0.5f)) * limbSwingAmount;
        float moveAnim4 = Mth.sin((float)(limbSwing * 0.9f - 0.9f)) * limbSwingAmount;
        float moveAnim4d = Mth.sin((float)(limbSwing * 0.9f - 0.9f + 0.5f)) * limbSwingAmount;
        float breatheAnim = Mth.sin((float)(ageInTicks * 0.2f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        this.head.xRot += breatheAnim * 0.02f;
        this.body1.xRot += breatheAnim * 0.005f;
        this.butt.xRot += -breatheAnim * 0.015f;
        this.innerHead.xRot += facePitch;
        this.innerHead.yRot += faceYaw;
        this.innerFrontLeg1.zRot += -moveAnim1 * (float)Math.PI / 6.0f;
        this.innerFrontLeg1.xRot += -0.3926991f * limbSwingAmount;
        this.lowerFrontLeg1.zRot += moveAnim1d * (float)Math.PI / 6.0f + 0.2617994f * limbSwingAmount;
        this.innerFrontLeg2.zRot += moveAnim2 * (float)Math.PI / 6.0f;
        this.innerFrontLeg2.xRot += -0.3926991f * limbSwingAmount;
        this.lowerFrontLeg2.zRot += -(moveAnim2d * (float)Math.PI / 6.0f + 0.2617994f * limbSwingAmount);
        this.innerMiddleLeg1.zRot += -moveAnim3 * (float)Math.PI / 6.0f;
        this.innerMiddleLeg1.xRot += -0.8975979f * limbSwingAmount;
        this.lowerMiddleLeg1.zRot += moveAnim3d * (float)Math.PI / 6.0f + 0.3926991f * limbSwingAmount;
        this.innerMiddleLeg2.zRot += moveAnim4 * (float)Math.PI / 6.0f;
        this.innerMiddleLeg2.xRot += -0.8975979f * limbSwingAmount;
        this.lowerMiddleLeg2.zRot += -(moveAnim4d * (float)Math.PI / 6.0f + 0.3926991f * limbSwingAmount);
        this.backLeg1.xRot += -moveAnim4 * (float)Math.PI / 5.0f + 0.2617994f * limbSwingAmount;
        this.backLeg2.xRot += -moveAnim1 * (float)Math.PI / 5.0f + 0.2617994f * limbSwingAmount;
        this.body2.xRot += -moveAnim * (float)Math.PI / 20.0f;
        this.head.xRot += moveAnim * (float)Math.PI / 20.0f;
        if (renderState.attackTime > 0.0f) {
            float swingAnim = Mth.sin((float)(renderState.attackTime * (float)Math.PI));
            this.body1.xRot -= swingAnim * (float)Math.PI / 2.5f;
            this.innerFrontLeg1.zRot += swingAnim * (float)Math.PI / 5.0f;
            this.innerFrontLeg2.zRot -= swingAnim * (float)Math.PI / 5.0f;
            this.innerMiddleLeg1.yRot -= swingAnim * (float)Math.PI / 2.5f;
            this.innerMiddleLeg2.yRot += swingAnim * (float)Math.PI / 2.5f;
            this.head.xRot += swingAnim * (float)Math.PI / 3.0f;
            this.butt.xRot += -swingAnim;
        }
    }
}

