/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class EndersoulParticle
extends TextureSheetParticle {
    private EndersoulParticle(ClientLevel clientLevel, double x, double y, double z, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(clientLevel, x, y, z, 0.0, 0.0, 0.0);
        this.lifetime = (int)(Math.random() * 15.0) + 10;
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        this.xd += xSpeedIn;
        this.yd += ySpeedIn;
        this.zd += zSpeedIn;
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.4f + 2.4f);
        float color = this.random.nextFloat() * 0.6f + 0.4f;
        this.rCol = color * 0.9f;
        this.gCol = color * 0.3f;
        this.bCol = color;
        this.hasPhysics = false;
    }

    public float getQuadSize(float partialTicks) {
        float scale = 1.0f - ((float)this.age + partialTicks) / (float)this.lifetime;
        scale *= scale;
        scale = 1.0f - scale;
        return this.quadSize * scale;
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd += 0.002;
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.9;
        this.yd *= 0.9;
        this.zd *= 0.9;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType particleType, ClientLevel clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EndersoulParticle endersoulParticle = new EndersoulParticle(clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
            endersoulParticle.pickSprite(this.spriteSet);
            return endersoulParticle;
        }
    }
}

