/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.MutantSkeletonPartModel;
import fuzs.mutantmonsters.client.renderer.entity.MutantSkeletonRenderer;
import fuzs.mutantmonsters.client.renderer.entity.state.BodyPartRenderState;
import fuzs.mutantmonsters.world.entity.MutantSkeletonBodyPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class BodyPartRenderer
extends EntityRenderer<MutantSkeletonBodyPart, BodyPartRenderState> {
    private final MutantSkeletonPartModel model;

    public BodyPartRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new MutantSkeletonPartModel(context.bakeLayer(ModelLayerLocations.MUTANT_SKELETON_PART), context.bakeLayer(ModelLayerLocations.MUTANT_SKELETON_PART_SPINE));
    }

    public void extractRenderState(MutantSkeletonBodyPart entity, BodyPartRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = entity.getXRot(partialTick);
        reusedState.yRot = entity.getYRot(partialTick);
        reusedState.bodyPart = entity.getBodyPart();
    }

    public BodyPartRenderState createRenderState() {
        return new BodyPartRenderState();
    }

    public void render(BodyPartRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.xRot));
        poseStack.scale(1.2f, -1.2f, -1.2f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(this.model.renderType(MutantSkeletonRenderer.TEXTURE_LOCATION));
        this.model.getBodyPart(renderState.bodyPart).render(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

